<?php
interface crudable {

	public static function getFieldValidations(): array;
	
	public static function getFieldHelpTexts(): array;
	
	public static function getById(int $id): ?array;
	
	public static function getByName(string $name): ?array;

	public static function getByProperty(string $key, string $value, array $request=array()): ?array;

	public static function getByProperties(array $keyValuePairs, array $request=array()): ?array;

	public static function getAll(array $request=array()): ?array;
	
	public static function create(array $request=array()): array;
	
	public static function update(int $id, array $request=array()): array;
	
	public static function delete(int $id): array;
	
	public static function canCreate(): bool;
	
	public static function canUpdate(int $id): bool;
	
}
