<?php class beamline extends baseobject {

    protected static $fields=array(
        'name'=>validator::REQUIRED,
        'shipmentdestinationid'=>array(validator::REQUIRED, validator::INTEGER),
        'detectormanufacturer'=>validator::ANY,
        'detectormodel'=>validator::ANY,
        'detectortype'=>validator::ANY,
    );

    protected static $helpTexts=array(

    );

	protected static $adminSelect='SELECT SQL_CALC_FOUND_ROWS beamline.*, shipmentdestination.name AS shipmentdestinationname
        FROM beamline, shipmentdestination, project
        WHERE beamline.shipmentdestinationid=shipmentdestination.id
            AND beamline.projectid=project.id
    ';
    protected static $normalSelect='SELECT SQL_CALC_FOUND_ROWS beamline.*, shipmentdestination.name AS shipmentdestinationname
        FROM beamline, shipmentdestination, project
        WHERE beamline.shipmentdestinationid=shipmentdestination.id
            AND beamline.projectid=project.id
    ';
    public static $defaultSortOrder='shipmentdestination.name, beamline.name';

    public static function create(array $request = array()): array {
		shipment::setShipperAdmin();
        $sharedProject=project::getByName(baseproject::SHARED);
		if(!$sharedProject){
			throw new NotFoundException('Could not read shared project');
		}
        $request["projectid"]=$sharedProject['id'];
        $ret=parent::create($request);
		shipment::revertShipperAdmin();
		return $ret;
    }

    /**
     * @return bool
     * @throws NotFoundException
     */
    public static function canCreate(): bool {
        return session::isShipper() || session::isAdmin();
    }

    /**
     * @param $id
     * @return bool
     * @throws NotFoundException
     */
    public static function canUpdate($id): bool {
        return session::isShipper() || session::isAdmin();
    }

}