<?php class crystalscore extends baseobject {
	
	protected static $fields=array(
			'name'=>validator::REQUIRED,
			'crystalscoringsystemid'=>array(validator::REQUIRED, validator::INTEGER),
			'label'=>validator::REQUIRED,
			'color'=>array(validator::REQUIRED, validator::COLOR),
			'scoreindex'=>array(validator::REQUIRED, validator::INTEGER),
			'hotkey'=>array(validator::REQUIRED, validator::INTEGER),
	);
	
	protected static $helpTexts=array(
			'name'=>'A unique name for this score. Created automatically',
			'label'=>'Label shown to users',
			'color'=>'The highlight colour for this score',
			'scoreindex'=>'0 is the lowest score, increase by 1 per score',
			'hotkey'=>'The hotkey for this score in the drop viewer (0-9 only)'
	);

	public static $defaultSortOrder='scoreindex ASC';

    /**
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws ForbiddenException
     * @throws NotFoundException
     * @throws ServerException
     */
	public static function create(array $request=array()): array {
		$project=project::getByName(baseproject::SHARED);
		if(!$project){
			throw new NotFoundException('Could not read shared project');
		}
		$request['projectid']=$project['id'];
        return parent::createByClassName($request,'crystalscore');
	}

	public static function canCreate(): bool {
		return crystalscoringsystem::canCreate();
	}

}