<?php class crystalscoringsystem extends baseobject {
	
	protected static $fields=array(
			'name'=>validator::REQUIRED,
			'iscurrent'=>validator::BOOLEAN,
	);
	
	protected static $helpTexts=array(
			'name'=>'A unique name for this scoring system',
			'iscurrent'=>'Whether this system should be used for new plates',
	);

    /**
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws NotFoundException if the Shared project is not found
     * @throws ForbiddenException
     * @throws ServerException
     */
	public static function create(array $request=array()): array {
		$request['projectid']=project::getSharedProjectId();
		return parent::createByClassName($request,'crystalscoringsystem');
	}

	/**
	 * @throws BadRequestException
	 * @throws ServerException
	 */
	public static function canCreate(): bool {
		return project::canCreateInProject(project::getSharedProjectId());
	}

    /**
     * @param $id
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws NotFoundException
     * @throws ServerException
     */
	public static function getscores($id, array $request=array()): array {
		return crystalscore::getbyproperty('crystalscoringsystemid',$id, $request);
	}

    /**
     * Returns the crystalscore in this system that best matches the supplied name, or null. Case-insensitive.
     * First looks for an exact match of $name, then for a score beginning with $name, then for one containing $name, then returns null.
     * @param $id
     * @param $name
     * @return mixed|void|null
     * @throws BadRequestException
     * @throws NotFoundException
     * @throws ServerException
     */
    public static function getScoreBestMatchingName($id, $name){
        $name=strtolower($name);
        $scores=static::getscores($id);
        if(!$scores){ return null; }
        foreach ($scores['rows'] as $score) {
            if (strtolower($score['label'])==$name){
                return $score;
            }
        }
        foreach ($scores['rows'] as $score) {
            if (stripos($score['label'],$name)===0){
                return $score;
            }
        }
        foreach ($scores['rows'] as $score) {
            if (stripos($score['label'],$name)!==false){
                return $score;
            }
        }

    }

}
