<?php class datasetlocation extends baseobject {

    protected static $fields=array(
        'name'=>validator::ANY, //generated automatically
        'datasetid'=>[VALIDATOR::REQUIRED, validator::INTEGER],
        'type'=>validator::REQUIRED,
		'datalocation'=>validator::REQUIRED,
    );

    protected static $helpTexts=array(
        'datasetid'=>'The dataset to which this location refers',
        'starrating'=>'A subjective score of this dataset\'s importance',
        'type'=>'One of Original, Intermediate, Open-Access, Other',
        'datalocation'=>'The path, URL, or DOI where the raw data can be found'
    );


    public static function create(array $request = array()): array {
		shipment::setShipperAdmin();
        $datasetId=$request['datasetid'];
        if(!$datasetId){ throw new BadRequestException("Dataset ID not specified"); }
        $dataset=dataset::getById($datasetId);
        if(!$dataset){ throw new NotFoundException("Dataset not found"); }
        if(session::getUserId() !==1*$dataset['projectownerid'] && session::isShipper() && !session::isAdmin()){
            throw new ForbiddenException('Only the project owner can manage datasets');
        }
        $request['projectid']=$dataset['projectid'];
        $request['name']='datasetlocation'.microtime(true);
        $ret=parent::create($request);
		shipment::revertShipperAdmin();
        return $ret;
    }

    public static function update($id, $request=array()): array {
		shipment::setShipperAdmin();
        $ret=parent::update($id, $request);
		shipment::revertShipperAdmin();
        return $ret;
    }


    /**
     * @return bool
     */
    public static function canCreate(): bool {
        return true; //but checked in create()
    }

    /**
     * @param $id
     * @return bool
     */
    public static function canUpdate($id): bool {
        return true; //but checked in create()
    }

}