<?php class imagingparametersversion extends baseobject {
	
	protected static $fields=array(
			'name'=>validator::REQUIRED,
			'manufacturerdatabaseid'=>array(validator::REQUIRED,validator::INTEGER),
			'imagingparametersid'=>array(validator::REQUIRED,validator::INTEGER)
	);
	
	protected static $helpTexts=array(
			'name'=>'A unique name for this set of imaging parameters',
			'manufacturerdatabaseid'=>'The ID of this version in the imager manufacturer database',
			'imagingparametersid'=>'The database ID of the parent Imaging Parameters, of which this is a version'
	);

    /**
     * @param $id
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws NotFoundException
     * @throws ServerException
     */
	public static function getimagersettings($id,$request=array()){
		return imagingsetting::getByProperty('imagingparametersversionid', $id, $request);
	}
	
}