Homepage.registerBrick({
	name:"fi_oulu_DiskUsage",
	title:"Disk usage overview",
	description:"An overview of disk usage on the server, including mounted network drives",
	adminOnly:true,
	version:1,
	height:1,
	width:1,
	url:"/api/diskusage",
	onSuccess:function(transport,box){
		let alertThreshold=85;
		let warnThreshold=95;
		let statusColors={
			normal: "#0c0",
			alert:  "#f60",
			warn:   "#c00",
		};
		let disks=transport.responseJSON.rows;
		box.querySelector(".boxbody").innerHTML="";
		disks.forEach(function(d){
			let alertState="normal";
			if((1*d["percent"])>=alertThreshold){ alertState='alert'; }
			if((1*d["percent"])>=warnThreshold){ alertState='warn'; }
			let diskDiv=document.createElement("div");
			let capacityBar=document.createElement("div");
			diskDiv.appendChild(capacityBar);
			let fullBar=document.createElement("div");
			capacityBar.appendChild(fullBar);
			let percentFull=document.createElement("span");
			percentFull.innerHTML=d["percent"]+"%";
			diskDiv.appendChild(percentFull);
			let label=document.createElement("span");
			let parts=d["mountpoint"].split("/");
			let lastPart=parts[parts.length-1];
			if(!lastPart){ lastPart=parts[parts.length-2]; }
			//label.innerHTML=d.mountpoint;
			label.innerHTML=lastPart;
			diskDiv.title="Size "+d["size"]+", "+d["used"]+" used, "+d["free"]+" free ("+d["filesystem"]+")";
			diskDiv.appendChild(label);
			box.querySelector(".boxbody").appendChild(diskDiv);
			diskDiv.style.padding="0.25em 0";
			diskDiv.style.lineHeight="1.5em";
			diskDiv.style.borderBottom="1px solid #999";
			capacityBar.style.width="40%";
			capacityBar.style.display="inline-block";
			capacityBar.style.margin="0em 1em 0 0";
			capacityBar.style.backgroundColor="#ccc";
			capacityBar.style.borderRadius="3px";
			capacityBar.style.boxShadow="2px 2px 2px #666 inset";
			capacityBar.style.fontSize="80%";
			capacityBar.style.height="1em";
			capacityBar.style.overflow="hidden";
			capacityBar.style.position="relative";
			capacityBar.style.top="0";
			fullBar.style.position="absolute";
			fullBar.style.top="0";
			fullBar.style.left="0";
			fullBar.style.bottom="0";
			fullBar.style.width=d["percent"]+"%";
			fullBar.style.backgroundColor=statusColors[alertState];
			fullBar.style.boxShadow="1px 1px 1px #333 inset";
			percentFull.style.display="inline-block";
			percentFull.style.width="4em";
			percentFull.style.fontWeight="bold";
			percentFull.style.color=statusColors[alertState];
		});
	},
	onFailure:function(transport,box){
		let error="Could not get disk usage information.";
		if(transport.responseJSON && transport.responseJSON.error){
			error=transport.responseJSON.error;
		}
		box.querySelector(".boxbody").innerHTML=error;
	}
});
