Homepage.registerBrick({
	name:"fi_oulu_Imagers",
	title:"Imager overview",
	description:"An overview of imager load",
	version:2,
	height:1,
	width:1,
	url:"/api/imager/isinuse/1",
	onSuccess:function(transport,box){
		let statusColors={
			active_normal: "#0c0",
			active_alert:  "#cc0",
			active_warn:   "#c00",
			expired_normal:"#070",
			expired_alert: "#770",
			expired_warn:  "#700",
		};
		let imagers=transport.responseJSON.rows;
		box.querySelector(".boxbody").innerHTML="";
		imagers.forEach(function(im){
			if(im["platecapacity"]*1<10 || "Unknown"===im.manufacturer){ return; } //from this iteration
			let activePercent=(100*im["platesactive"]/im["platecapacity"]);
			let expiredPercent=(100*im["platesexpired"]/im["platecapacity"]);
			let alertState="normal";
			if((1*im["platesactive"])+(1*im["platesexpired"])>=1*im["alertlevel"]){ alertState='alert'; }
			if((1*im["platesactive"])+(1*im["platesexpired"])>=1*im["warninglevel"]){ alertState='warn'; }
			let title=im["platesactive"]+' active, '+im["platesexpired"]+' expired, '+(1*im["platecapacity"]-((1*im["platesactive"])+(1*im["platesexpired"])))+' free';
			let imagerDiv=document.createElement("div");
			let link=document.createElement("a");
			link.href="/imager/"+im.id;
			link.innerHTML=im["friendlyname"]+" ("+im.name+")";
			if("Rigaku"===im.manufacturer){
				title="Cannot determine imager loading from its database";
				link.innerHTML+=" - cannot determine loading"
			} 
			imagerDiv.title=title;
			imagerDiv.appendChild(link);
			let capacityBar=document.createElement("div");
			imagerDiv.appendChild(capacityBar);
			let activeBar=document.createElement("div");
			capacityBar.appendChild(activeBar);
			let expiredBar=document.createElement("div");
			capacityBar.appendChild(expiredBar);
			box.querySelector(".boxbody").appendChild(imagerDiv);
			activeBar.style.position="absolute";
			activeBar.style.top="0";
			activeBar.style.left="0";
			activeBar.style.bottom="0";
			activeBar.style.width=activePercent+"%";
			activeBar.style.backgroundColor=statusColors['active_'+alertState];
			activeBar.style.boxShadow="1px 1px 1px #333 inset";
			expiredBar.style.position="absolute";
			expiredBar.style.top="0";
			expiredBar.style.left=activePercent+"%";
			expiredBar.style.bottom="0";
			expiredBar.style.width=expiredPercent+"%";
			expiredBar.style.backgroundColor=statusColors['expired_'+alertState];
			expiredBar.style.boxShadow="1px 1px 1px #333 inset";
			imagerDiv.style.padding="0.25em 0";
			imagerDiv.style.borderBottom="1px solid #999"
			capacityBar.style.margin="0.25em 0 0.5em 0";
			capacityBar.style.minHeight="1em";
			capacityBar.style.position="relative";
			capacityBar.style.top="0";
			capacityBar.style.fontSize="80%";
			capacityBar.style.overflow="hidden";
			capacityBar.style.height="1em";
			capacityBar.style.borderRadius="3px";
			capacityBar.style.backgroundColor="#ccc";
			capacityBar.style.boxShadow="2px 2px 2px #666 inset";
		});
	}
});