<?php
include_once(dirname(__DIR__,3).'/client/help/_common/helphead.php');
?>

<h1>Containers</h1>

<p>As the name suggests, a container in IceBear is something designed to hold something else. A shipping dewar can contain pucks, a puck can contain pins, and a pin can contain a crystal.</p>
<p>To help you record crystal fishing and send shipments to synchrotrons, IceBear needs to know about the containers you use. In most cases, you can create them as and when you need them, but registering them in bulk means you won't have to do it later.</p>
<p>Crystallization plates are handled differently; IceBear doesn't regard them as containers.

<h2>Container categories</h2>

<p>This is the broadest classification possible, for example "Puck". It doesn't hold any information beyond the name.</p>
<p>The container category is used for basic sanity checking; a crystal will fit into a pin, but a dewar will not.</p>
<p>IceBear comes with three container categories pre-defined: "Dewar", "Puck" and "Pin".</p>
<p>You can view a list of all container categories from the main menu. If you have permission, you will also be able to create new container categories.</p>

<h2>Container types</h2>

<p>This describes a kind of container, within the broader category, but does not describe a specific container. As well as the name and category, 
it defines how many "positions" are available within containers of this type - that is, how many items can be contained.</p>
<p>IceBear has four pre-defined container types: Dewar, pin, 10-position SPINE puck, and 16-position Unipuck.</p>
<p>You can view a list of all container types from the main menu. If you have permission, you will also be able to create new container types.</p>

<h2>Container</h2>

<p>This is a specific physical item like a pin, which you can touch.</p>
<p>A container will have a container type ("This is a SPINE puck") as well as a name. If the container has a barcode, use the barcode as its name.</p>

<h3>Registering containers</h3>
<p>You need to be in the Technicians, Shippers or Administrators usergroup to do this.</p>
<p>Things will go far more smoothly if IceBear knows about containers before you try to use them in a shipment. You can register individual
containers from the main menu.</p>
<p>For registering large numbers of containers, either when first commissioning IceBear or when buying a new box of pins, you will find it
quicker and easier to add the "Container management" brick to your homepage. This lets you select the container type then scan all the barcodes. 
See the help within that brick for further details.</p>

<h3>Emptying containers</h3>
<p>You need to be in the Technicians, Shippers or Administrators usergroup to do this.</p>
<p>After a shipment is returned, you will need to tell IceBear which containers are empty and can be re-used. In many cases this will be all of
them, but for various reasons you may want to keep some of the crystals and send them again.</p>
<p>You can navigate to the individual container by scanning its barcode in the "Find by barcode" box in the top right-hand corner of IceBear.
There, you can remove items from the container, with the option of unpacking or retaining the contents.

<?php
include_once(dirname(__DIR__,3).'/client/help/_common/helpfoot.php');
?>