<?php
include_once(dirname(__DIR__,3).'/client/help/_common/helphead.php');
?>

<h1>Drop viewer</h1>

<p>The drop viewer allows you to </p>

<ul><li>see and score images of all drops for a plate inspection</li>
<li>measure crystals within a drop</li>
<li>view historical images for a given drop</li>
<li>see the crystallization conditions, if they have been entered</li>
<li>select and annotate interesting crystals, and read others' notes and files for those crystals</li></ul>

<h2>Measure and Score</h2>

<p>When you first open the drop viewer, you will see something like this:</p>

<figure>
	<img alt="" src="image001.jpg"/>
	<figcaption>The IceBear crystal drop viewer.</figcaption>
</figure>

<p>The viewer is in "Measure and Score" mode. You can select different modes using the buttons at the bottom right. Return to Measure and Score mode at any time by clicking the icon:</p>

<figure>
	<img alt="" src="image002.jpg"/>
	<figcaption>Icon for "Measure and Score" mode.</figcaption>
</figure>

<h3>Basic navigation</h3>

<p>You can choose to have the controls on the left of the screen if you prefer. Simply click the gear-wheel control at the top right, and choose the layout you want.</p>

<p>There is a link to the plate itself in the page header. The page header also shows the well and drop number being viewed.</p>

<p>At the top of the controls pane, there are "movie" controls for navigation by drop. You can jump to the first or last drop in the plate; go to the previous or next drop; or play all drop images one after the other, for hands-off viewing of all images in the plate. The delay between movie images can be adjusted with the small +/- controls above the
movie controls. The four-way arrow launches navigation mode, a plate overview where you can jump directly to any drop.</p>

<h3>Drop scoring</h3>

<p>Below the movie controls are the scoring controls. The actual scores shown may vary; they are usually imported from your
imaging system. If the image has already been scored, the score will be highlighted.</p>

<p>Score a drop by clicking the appropriate score, or by pressing the number key for that score.</p>

<p>By default, the drop viewer will advance to the next drop after scoring. This gives you a very fast way to view and score all images in your plate, using only the number keypad. If you want to turn this behaviour off, uncheck the "Go to next drop after scoring" box under the scores.</p>

<p>Note that you may not have permission to score a particular plate. In that case, you can see but not change the score, and the "Go to next drop after scoring" option is not shown.</p>

<h3>Image comparison</h3>

<p>If the plate has been imaged more than once, the first and latest images are shown underneath the scores.</p>

<p>Roll your mouse cursor over the images to show them in the main image pane. This can be useful for determining quickly whether a potentially interesting object has grown during the experiment or was there when the plate was set up.</p>

<h3>Measuring tool</h3>

<p>The measuring tool is off by default. Press <b>M</b> to activate and deactivate it. </p>

<figure>
	<img alt="" src="image003.jpg"/>
	<figcaption>The measuring tool.</figcaption>
</figure>

<p>The measuring tool has a series of circles spaced at 100 microns, with the thicker circles at 200-micron intervals. If the magnification of
the image is high enough, there will also be 20-micron circles for the first 200 microns. The
tool will follow your mouse as it moves over the image.</p>

<p>To measure a crystal or other feature, simply place your mouse over one end and read the distance at the other. In the
example above, the crystal is about 110 microns long.</p>

<p>The measuring tool is accurate as long as your imaging system provides the correct scale (microns per pixel) information. If you have a Formulatrix imager, the scale information is correct.</p>

<h2>Navigation and plate overview</h2>

<p>To open the navigation window, press <b>N</b> or click the icon:</p>

<figure>
	<img alt="" src="image004.png"/>
	<figcaption>The "Navigation and overview" icon.</figcaption>
</figure>

<p>The navigation window looks like this; the currently-selected well is highlighted with a dark red border:</p>

<figure>
    <img alt="" src="image005.jpg"/>
	<figcaption>Navigation and plate overview.</figcaption>
</figure>

<p>Below each image is a coloured area showing
its current score. </p>

<p>You can navigate around the plate by well
using the arrow keys, with Ctrl-left and Ctrl-right going backward and forward
by drop. For the current well, images for all drops are shown larger. Hovering
over a well with the mouse will also bring up these larger images.</p>

<p>If the plate has been imaged in both
visible and UV light, a light bulb icon is shown in the top left. Click the
icon to switch the navigation window between visible and UV images.</p>

<p>On the left is an icon for each drop
position; the example is a 1-drop plate. Clicking one of these icons shows the
images in that drop position.</p>

<p>To jump to the currently-selected drop and
close the navigation window, press <b>Enter</b> or click the well.</p>

<p>To leave the navigation window without
going to a new drop, press <b>Esc</b> or click the cross in the top right.</p>

<h2>Imaging History</h2>

<p>Imaging History mode allows you to see all
the images that have been taken of this drop since the plate was set up. Go to
Imaging History mode by clicking the icon at the bottom of the control pane:</p>

<figure>
    <img alt="" src="image006.jpg"/>
    <figcaption>The "Imaging history" icon.</figcaption>
</figure>

<p>Imaging History mode looks like this:</p>

<figure>
    <img alt="" src="image007.jpg"/>
    <figcaption>Drop imaging history.</figcaption>
</figure>

<h3>Images</h3>

<p>All images taken of this drop are shown in
the controls pane, oldest at the top, newest at the bottom. Beside each image,
the date and time are shown, along with the elapsed time since the first
imaging. If an image was scored, it will have a border in the colour for that
score; mouse over the colour to read the score.</p>

<p>To view any of the images in the main image
pane, mouse over it. Clicking the image will lock it in place so that you can
use the measuring tool (press <b>M</b> to activate).</p>

<h3>Movie controls</h3>

<p>In Imaging History mode, the movie controls
navigate you through the imaging history, not through the plate. To move to a
different drop, you will need to exit Imaging History mode, or open the
navigation/plate overview (press <b>N</b> or click the 4-way arrow).</p>

<p>You can go to the first or last image of
this drop, step backward and forward, or play all images of the drop one after
the other in date order. </p>

<h3>Light type controls</h3>

<p>If your plate has been imaged using both UV
and visible light, you can hide all UV or all visible images by clicking the
button.</p>

<p>If images are hidden, the movie controls
will only work on the ones that are not hidden. You can therefore play a movie
of your crystal growing in UV, or in visible light.</p>

<p>Here, all visible images have been hidden,
leaving only the UV images:</p>

<figure>
    <img alt="" src="image008.jpg"/>
    <figcaption>Imaging history, filtered to show only UV images.</figcaption>
</figure>

<h2>Drop Information</h2>

<p>Drop Information mode shows the protein and
the crystallization conditions, where these have been provided. Go to Drop
Information mode by clicking the icon at the bottom of the control pane:</p>

<figure>
    <img alt="" src="image009.jpg"/>
    <figcaption>The "Drop information" icon.</figcaption>
</figure>

<p>Drop information mode looks like this:</p>

<figure>
    <img alt="" src="image010.jpg"/>
    <figcaption>A drop image and its information.</figcaption>
</figure>

<p>Most of the information here must be
provided by the plate owner. This can be done on the plate's view page. Click
the link in the page header to go to the plate.</p>

<p>The information in the Plate and Incubation
sections is imported from your imaging system. The temperature is set from
IceBear's record of the imager temperature; it is important that the imager's
temperature is set correctly!</p>

<h2>Crystal Selection</h2>

<p>Crystal Selection mode is where you select
interesting crystals and annotate them. Go to Crystal Selection mode by
clicking the icon at the bottom of the control pane:</p>

<figure>
    <img alt="" src="image011.png"/>
    <figcaption>The "Crystal selection" icon.</figcaption>
</figure>

<p>Crystal Selection mode looks like this:</p>

<figure>
    <img alt="" src="image012.jpg"/>
    <figcaption>Crystal selection in the drop viewer.</figcaption>
</figure>

<p>Interesting crystals are marked on the
image with crosshairs. You can either click on an existing crosshair, or click
anywhere on the image to mark a new one.</p>

<p>You may not have permission to mark new crystals
on the image. If not, you will still be able to click on any existing
crosshairs.</p>

<p>Once you have selected or marked a crystal,
you will be able to see more information about it:</p>

<figure>
    <img alt="" src="image013.jpg"/>
    <figcaption>Crystal information.</figcaption>
</figure>

<p>The crystal is assigned a number within the
drop, starting from 1.</p>

<p>The crystal has a "sample name", which will
be sent to the synchrotron along with the crystal. There is a pre-defined part,
generated from the plate barcode and the crystal's location within the plate;
this is guaranteed to be unique within your system, as long as plate barcodes
are not duplicated. You can add to this name if you wish - but keep the name
short. Certain naming restrictions may be imposed by the synchrotron's shipping
systems; IceBear enforces the ones that it knows about, but you should
familiarise yourself with the restrictions imposed by your synchrotron(s).</p>

<p>You can attach files to the crystal. Click
the button and select your file; it will be uploaded automatically. Attached
files will open in a new window if clicked.</p>

<p>You can also write notes on the crystal, in
the box provided. Click "Save note" to attach the note to the crystal.</p>

<h2>Drop viewer: Keyboard shortcuts</h2>

<table>
<tr><td colspan="2"><i>Imaging history mode:</i></td></tr>
<tr><td><b>Left/right arrow</b></td><td>Go back/forward through history</td></tr>
<tr><td colspan="2"><i>Measure And Score mode:</i></td></tr>
<tr><td><b>R</b></td><td>Swap in first image (while key is pressed)</td></tr>
<tr><td><b>T</b></td><td>Swap in last image (while key is pressed)</td></tr>
<tr><td colspan="2"><i>Other modes:</i></td></tr>
<tr><td><b>Arrow keys</b></td><td>Go up/down/left/right by well </td></tr>
<tr><td><b>Ctrl+left/right arrow</b></td><td>Go to previous/next drop</td></tr>
<tr><td><b>Shift+left/right arrow</b></td><td>Go to previous/next drop scored above your chosen score threshold</td></tr>
<tr><td colspan="2"><i>All modes:</i></td></tr>
<tr><td><b>M</b></td><td>Toggle the measuring tool on and off (off by default)</td></tr>
<tr><td><b>N</b></td><td>Open the navigation window</td></tr>
<tr><td><b>0-9</b></td><td>Score the drop</td></tr>
<tr><td colspan="2"><i>xtalPiMS shortcuts also work:</i></td></tr>
<tr><td><b>A/D</b></td><td>Go to previous/next drop</td></tr>
<tr><td><b>S</b></td><td>Start/stop movie</td></tr>
<tr><td><b>Q</b></td><td>First drop in plate</td></tr>
<tr><td><b>E</b></td><td>Last drop in plate</td></tr>
</table>
<?php
include_once(dirname(__DIR__,3).'/client/help/_common/helpfoot.php');
?>