<?php
include_once(dirname(__DIR__,3).'/client/help/_common/helphead.php');
?>

<h1>Plates</h1>

<h2>Creating a plate</h2>
<p>If you have integrated IceBear with your imaging system, plates will be imported automatically, along with their plate
    type, images, etc.</p>
<p>If you don't have imagers, or are working with plate formats that won't fit in your imagers, you will need to create
    a plate manually. From the main menu, select "Add a plate".</p>
<figure>
    <img alt="" src="create.png" />
    <figcaption>Creating a plate in IceBear.</figcaption>
</figure>
<p>In the <strong>Barcode</strong> field, choose a unique identifier. You should avoid spaces or special characters and
    keep this as short as reasonably possible; it may end up in a filename somewhere.</p>
<p>Choose the correct project and plate type for your plate, then click <strong>Create</strong>. You will then see the
    new page for your plate.</p>

<h2>Viewing a plate</h2>
<figure>
	<img alt="" src="view.png" />
	<figcaption>A plate in IceBear. Its imaging history is shown in the Inspections tab.</figcaption>
</figure>

<p>You can navigate to the plate's project by clicking its name in the Details box, or by clicking the project icon in
    the top left.</p>

<h3>Details</h3>
<p>The details box contains some basic information about the plate, including its barcode and plate type.</p>
<p>The plate's project is also shown. Click the project name to go to it. If this is "Default Project", you should assign
    it to a real working project. You can do this by assigning a protein to the plate in the Protein tab. Plates in the
    default project can only be seen by the plate owner.</p>
<p>The plate's owner is determined from the imaging system; in Formulatrix systems, this is done by matching the plate
    owner's email address in RockMaker to an IceBear user.</p>
<p>The plate importer may recognise some RockMaker "users" as defaults, that is, they indicate that the correct plate
    owner was not properly set in RockMaker. If you didn't set yourself as the plate owner in RockMaker, and the RockMaker
    default is recognised by the importer, IceBear will assign your plate to an "Unknown User"; only administrators will
    be able to see the plate and sort it out.</p>

<h3>The Inspections tab</h3>
<p>This tab shows all the times that the plate has been imaged.  The imager and temperature for each imaging session are
    also shown.</p>
<p>The light bulb shows you what kind of imaging was done: A yellow bulb is visible light, and a purple bulb is UV.</p>
<p>Click on any date/time to go to the drop viewer and see the images. Most of the time, you'll want the most recent
    images, so click the one at the top. </p>

<h4>Adding inspections</h4>
<p>You may have the option to add manual inspections to the plate. Click <strong>Create new manual inspection for this
        plate...</strong> to open the inspection form.</p>
<figure>
    <img alt="" src="../imagingsession/create_basics.png" />
    <figcaption>Creating a plate inspection.</figcaption>
</figure>
<p>IceBear assumes that manually-added images are taken in visible light (as opposed to, say, UV). Specify the date/time,
    and which imaging device was used - typically "+4 Microscope" or "+20 Microscope". Then click the
    <strong>Create</strong> button.</p>
<p>Now, you can attach images to your new inspection.</p>
<figure>
    <img alt="" src="../imagingsession/create_images.png" />
    <figcaption>Adding images to a plate inspection.</figcaption>
</figure>
<p>For plates with more than one sub-well per well position, first click the correct drop number on the left.</p>
<p>Click the correct well for your image. You can then select the image to upload, and a thumbnail of it will appear in
    the well.</p>
<p>To remove an image that you have already uploaded, click it. Click OK when you are asked to confirm. The image will
    disappear.</p>
<p>If you have scale information for your image, you can enter it into IceBear. Doing this will let you use the Measure
    tool in the drop viewer. Right-click the image and enter the scale into the box that appears. Note that the unit is
    microns per pixel.</p>
    <figure>
        <img alt="" src="../imagingsession/create_setscale.png" />
        <figcaption>Setting the scale of a drop image.</figcaption>
    </figure>

<p>When you have finished uploading images, you can view the inspection in the Drop Viewer and mark crystals for onward
    processing.</p>

<h4>Editing inspections</h4>
<p>Click the <strong>Edit...</strong> button beside the inspection. This works just like creating one.</p>

<?php include_once '../crystal/listtab.php'; ?>

<h3>The Protein tab</h3>

<figure>
	<img alt="" src="proteintab.png" />
	<figcaption>The Protein tab.</figcaption>
</figure>

<p>If you have already set the protein for this plate, you will see some basic information about it here.</p>
<p>You can also set the protein buffer and protein concentration.</p>
<h4>Setting the protein</h4>
    <p>If you have not set the protein, click the <strong>Choose...</strong> button. A box opens showing all the projects and
    proteins you can see:</p>

<figure>
	<img alt="" src="settingprotein.png" />
	<figcaption>Setting the protein.</figcaption>
</figure>
 
<p>Step down through the project and protein to locate the right construct. Click "Use this construct".</p>
<p>IceBear sets the construct into the relevant sub-well in all wells of the plate, and puts the plate into the construct's
    project. From here on, anyone with permissions on that project is able to see the plate in IceBear.</p>
<p>Once you have chosen the construct for one sub-position, you can copy it to the others or choose a different construct
    within the same project.</p>
<p>If you have already set the protein for this plate, you can change it, but only within the same project.</p>

<h3>The Screen tab</h3>
<p>The Screen tab is where you give IceBear information about the crystallization conditions in your plate.</p>
<p>Note that you must set the protein and construct before you can enter screen information.</p>
<p>If the screen has not been set, you will have two choices. Either choose a standard screen already in IceBear, or
    upload details of an optimization screen.</p>

<figure>
	<img alt="" src="screennotset.png" />
	<figcaption>The Screen tab, before setting a screen.</figcaption>
</figure>

<p>IceBear can understand screen information in the .csv format output by Mimer. It also understands some XML formats.
    It will extract the conditions from the file, and attach the file to the plate in the Files tab. If your format is
    not supported, you can always upload the file directly into the Files tab.</p>
<p>After setting the screen, the Screen tab will look something like this:</p>

<figure>
	<img alt="" src="screenset.png" />
	<figcaption>The Screen tab, showing the screen conditions.</figcaption>
</figure>
 
<h3>The Drop Conditions tab</h3>
<p>The Drop Conditions tab lets you specify the volume of well and protein solution used in each position in your plate:</p>

<figure>
	<img alt="" src="dropconditionstab.png" />
	<figcaption>The Drop Conditions tab.</figcaption>
</figure>

<p>The layout of the drops within the well should look like the actual plate, and the numbering of the drops should
    correspond to the drop numbers in the imager. If this is not the case, ask your administrator to change the "drop
    mapping" for the plate type.</p>

<?php include '../_common/filesnotestabs.php';?>

<h2>Destroying a plate</h2>
<p>You can tell IceBear that you have destroyed your plate. To do this, click the <strong>Destroy plate</strong> button.</p>
<p>This disables some functions, such as creating manual plate inspections. You can also see that the plate has been
    destroyed, so you don't waste time looking for it.</p>

<?php
include_once(dirname(__DIR__,3).'/client/help/_common/helpfoot.php');
?>