<?php
include_once(dirname(__DIR__,3).'/client/help/_common/helphead.php');
?>
<h1>Plate types</h1>

<p>Every plate in IceBear needs to have a plate type. The plate type describes the plate layout - rows, columns, and subpositions.</p>
<h2>Listing plate types</h2>
<p>To see a list of all plate types in IceBear, click "Find plate types" from the main menu.</p>

<figure>
	<img alt="" src="list.png" />
	<figcaption>A list of plate types in IceBear.</figcaption>
</figure>

<h2>Viewing and editing a plate type</h2>
<p>The plate type page looks like this:</p>

<figure>
	<img alt="" src="view.png" />
	<figcaption>A plate type.</figcaption>
</figure>

<p>Most people don't have permission to edit plate types. Only people in the Administrators and Technicians usergroups can do this,
unless an administrator has changed the permissions.</p>
<h3>Details</h3>
<p>The Details box shows basic information about the plate type:</p>
<ul><li><b>Name</b> - The name of the plate type. Note that this must match the name of the plate type in your imaging system!</li>
<li><b>Number of rows</b> - How many rows are in plates of this type. For a typical 96-well plate, this is 8.</li>
<li><b>Number of columns</b> - How many columns are in plates of this type. For a typical 96-well plate, this is 12.</li>
<li><b>Drops per well</b> - How many drops are in each well of the plate.</li>
<li><b>Drop mapping</b> - How the drops are numbered within the well. This field is explained further below.</li>
</ul>
<p>If you do have permission to edit plate types, beware: If the plate type was imported from your imaging system, you should not change anything 
except the drop mapping.</p>
<h3>The Drop Mapping field</h3>
<p>Different sites, and even different instruments within the same lab, can have different understandings of the well layout. When transferring
plates, it becomes important to describe one side's understanding to the other. "Their drop 3 is our drop 1." The Drop Mapping field
attempts to describe the local understanding, at least as far as the imaging system is concerned.</p>
<p>The Drop Mapping field makes no attempt to describe well or subposition dimensions, only which drop has which number.</p>
<h3>Plates tab</h3>
<p>Here you can see a list of the plates that have this plate type.</p>
<?php include '../_common/filesnotestabs.php'; ?>
<h2>Creating a new plate type</h2>
<p>You can only create new plate types if you are in the Administrators or Technicians usergroup.</p>
<p>IceBear will import plate types from your imaging system. It is recommended that you don't create plate types yourself; instead,
create it in your imager software and let IceBear import it with the first plate of that type.</p>
<p>If you want to do it anyway, or if you don't have an imager, click "Create new..." in the header of the plate type list page, or click "Add a plate type" from
the main menu.</p>

<?php
include_once(dirname(__DIR__,3).'/client/help/_common/helpfoot.php');
?>