<?php
include_once(dirname(__DIR__,3).'/client/help/_common/helphead.php');
?>

<h1>Projects</h1>
<p>Everything in IceBear is put into a project. The access rights on the project determine who can see it - and everything in it.</p>
<p>Usually, you would want to have one project per protein. Your plates belong in the project for their protein.</p>

<h2>Special projects</h2>
<p>There are two projects that have a special purpose: Shared and Default.

<h3>Shared project</h3>
<p>This project holds items that are likely to be common to all people. For example, equipment such as imagers would be in the Shared project. Plate types, standard screens, etc., are also likely to belong in the Shared project.</p>
<p>By default, everyone can see items in the Shared project but only people in the Technicians usergroup can modify them.</p>

<h3>Default project</h3>
<p>IceBear imports plates from the imaging system. It knows who owns the plate, but does not know what is in it. Therefore, it puts the plate into "Default project". Nobody can see the default project, but the plate owner can see the plate. They should set its protein correctly, to move it into the correct project. From then on, the project's permissions apply to the plate.</p>

<h2>The Project page</h2>
<p>A project in IceBear looks like this:</p>

<figure>
	<img src="view.png" alt="A project in IceBear" />
	<figcaption>An IceBear project. Plates in this project are listed in the Plates tab.</figcaption>
</figure>

<p>On the left there is some basic information about the project. If you are an administrator or if you own the project, you will be able to edit this. Note that, if you own the project, changing the owner might leave you unable to see the project.</p>

<h3>The Plates tab</h3>
<p>This lists all plates in this project, along with their owner. If any images in a plate have been scored, the best score for the plate is also shown here. </p>
<p>Click the plate barcode to go to the plate.</p>
<h3>The Proteins tab</h3>
<p>This is where you tell IceBear about the protein you are working with. Only the project owner can make changes in this tab.</p>
<p>You put your plates into the correct project by setting their protein, so it's important to put the protein information into your project.</p>

<figure>
	<img src="proteintab.png" alt="The Proteins tab" />
	<figcaption>The Proteins tab.</figcaption>
</figure>

<p>You can create several proteins in one project, but you most likely want only one protein per project. </p>
<p>A protein has a name and a description, as well as a &quot;protein acronym&quot; which will be used to identify it in safety and shipping data at the synchrotron.</p>
<p>Proteins have one or more constructs, each of which can have multiple sequences (that is, complexes are supported). DNA or protein sequences can be supplied.</p>

<?php include_once '../crystal/listtab.php'; ?>

<?php include_once '../dataset/listtab.php'; ?>

<h3>The Permissions tab</h3>
<p>This tab shows you which usergroups have permission to see and change items in the project (but not the project itself - only the owner and the administrators can do that). You may not have permission to see this tab.</p>

<figure>
	<img src="permissionstab.png" alt="The project permissions tab"/>
	<figcaption>The Permissions tab.</figcaption>
</figure>

<p>The permissions for each group are shown. Administrators always have full permissions on any project.</p>
<p>In this example, the "Everyone" group has no permissions at all - most users cannot even see the project. Those in "Bob's Group" can read, update and create things in this project. A third group can read but not change anything.</p>
<p>Project owners, and administrators, can change some of these permissions. If the tick or cross looks like a button, just click it to turn the permission on or off.</p>

<?php include '../_common/filesnotestabs.php';?>

<h2>Creating projects</h2>
<p>Only certain people have permission to create projects.</p>
<p>From the main menu, under Projects, click Add a project... From the list of projects, click the Create new... link at the top of the page.</p>
<p>Enter a name and a short description for the project, and click Create. You will be taken to the new project, where you can set up its permissions, etc. You can also change the owner, but - depending on your permissions and the project permissions - you may lose access to the project as soon as you do so. Set everything else up and change the project owner last.</p>

<?php
include_once(dirname(__DIR__,3).'/client/help/_common/helpfoot.php');
?>