/**
 * Fix to Prototype 1.7.2, to enable correct support of HTTP verbs beyond GET and POST.
 * 
 * In standard Prototype, verbs such as PUT and DELETE are translated into a POST, with
 * an additional _method=put parameter in the post body. This is how, e.g., Ruby works.
 * 
 * The whole mess is needed because older browsers (notably IE <10) don't support these
 * HTTP verbs. Prototype suports these older versions so opts for the Ruby hack. As at
 * v1.7.2, there is no way to override this non-standard behaviour, so here we replace
 * the entire Ajax.Request.request function with one that adheres to the standard.
 * 
 * The only change is to remove one if block that forces non-GET/POST to POST and adds
 * the _method parameter. See lines 25-31.
 * 
 * See issue discussion on GitHub: https://github.com/sstephenson/prototype/issues/280
 */
Ajax.Request.addMethods({
	request:function(url) {
	    this.url = url;
	    this.method = this.options.method;
	    var params = Object.isString(this.options.parameters) ?
	          this.options.parameters :
	          Object.toQueryString(this.options.parameters);
	
	    /* BEGIN: removed code that forces method to POST and appends _method to post body
	    if (!['get', 'post'].include(this.method)) {
	      // simulate other verbs over post
	      params += (params ? '&' : '') + "_method=" + this.method;
	      this.method = 'post';
	    }
	    END removed code */
	    
	    if (params && this.method === 'get') {
	      // when GET, append parameters to URL
	      this.url += (this.url.include('?') ? '&' : '?') + params;
	    }
	
	    this.parameters = params.toQueryParams();
	
	    try {
	      var response = new Ajax.Response(this);
	      if (this.options.onCreate) this.options.onCreate(response);
	      Ajax.Responders.dispatch('onCreate', this, response);
	
	      this.transport.open(this.method.toUpperCase(), this.url,
	        this.options.asynchronous);
	
	      if (this.options.asynchronous) this.respondToReadyState.bind(this).defer(1);
	
	      this.transport.onreadystatechange = this.onStateChange.bind(this);
	      this.setRequestHeaders();
	
	      //Need to send postBody for all methods except GET. In the original code, that meant POST.
	      //old: this.body = this.method == 'post' ? (this.options.postBody || params) : null;
	      this.body = this.method != 'get' ? (this.options.postBody || params) : null;

	      this.transport.send(this.body);
	
	      /* Force Firefox to handle ready state 4 for synchronous requests */
	      if (!this.options.asynchronous && this.transport.overrideMimeType)
	        this.onStateChange();
	
	    }
	    catch (e) {
	      this.dispatchException(e);
	    }
	  }
});