<?php

$pageTitle="Almost there...";
include realpath(__DIR__).'/../_common/header.php';

$icebearCodeVersion=config::getCodeVersion();

$messageHeader=str_replace("'","\'", htmlentities(config::get('core_prelogin_messageheader')));
$message=str_replace("'","\'", htmlentities(config::get('core_prelogin_message')));
?>

    <!--suppress JSUnresolvedReference -->
    <script type="text/javascript">
        let requestedUri='<?php echo $uri ?? ''; ?>';
        let icebearDbVersion='<?php echo config::get('core_icebearversion'); ?>';
        if(!icebearDbVersion){ icebearDbVersion='unknown'; }
        let icebearCodeVersion='<?php echo $icebearCodeVersion; ?>';
        if(!icebearCodeVersion){ icebearCodeVersion='unknown'; }
        let codeAndDbMatch=(icebearCodeVersion===icebearDbVersion);

        let messageHeader='<?php echo $messageHeader; ?>'.trim();
        let message='<?php echo $message; ?>'.trim();


        let grid=ui.grid();
        if(!codeAndDbMatch){
            grid.box({
                'id':'message',
                'title':'Database version mismatch',
                'classes':'r1 c2 h1 w1',
                'content':'<span style="color:red">IceBear can\'t be used at the moment because its database and code don\'t match.<br/><br/>The database version ('+
                            icebearDbVersion+') does not match the code version ('+icebearCodeVersion+'). An administrator needs to fix this</span>.'
            });
        } else {
            let b=grid.box({
                'id':"message",
                "title":"Link or create your IceBear account",
                "classes":"r1 c2 h1 w1",
                "content":""
            });
            b.innerHTML+="<p>You've authenticated successfully. We didn't find an existing IceBear account linked to those credentials.</p>" +
                "<p>If you have an account already, it's important to link it, so that your permissions are already set up and you don't end up with duplicate accounts.</p>" +
                "<p>If you don't have an account, you can create one now.";
            let b2=grid.box({
                'id':"loginbox",
                "title":"Link your IceBear account",
                "classes":"r2 c2 h1 w1",
                "content":"<h4>I already have an IceBear account</h4>" +
                    "<p>Log into your IceBear account; you will only have to do this once.<p>"

            });
            let frm2=b2.form({
                'action':'/api/Login'
            });
            frm2.textField({ label:"Username", name:'username' });
            frm2.passwordField({ label:"Password", name:'password' });
            frm2.submitButton({ label:'Link to my IceBear account' });
            frm2.hiddenField("linkaccount","linkaccount");
            frm2.onsubmit=function(){ Login.doLogin(); return false; };
            let b3=grid.box({
                'id':"createaccountbox",
                "title":"Create an IceBear account",
                "classes":"r3 c2 h1 w1",
                "content":""
            });
            b3.innerHTML+="<h4>I don't have an IceBear account</h4>" +
                "<p>Click the button below to create your account.</p>";
            let frm3=b3.form({
                'action':'/api/Login'
            });
            frm3.buttonField({ "label":"Create an IceBear account for me", "name":"createaccount" });
            frm3.querySelector("[type=button]").addEventListener("click",  Login.createAccount);
        }

    </script>

<?php include realpath(__DIR__).'/../_common/footer.php';