<?php 
/**
 * This is the basic "view" page for a project. Don't modify this. Instead, add tabs through extensions.js in this directory.
 */
if(!isset($data)){ $data=["name"=>"Project"]; } //It is.
$pageTitle='Project: '.$data['name'];
include realpath(__DIR__).'/../_common/header.php'; ?>
<script type="text/javascript"><?php include realpath(__DIR__).'/../../model/project/extensions.js'; ?></script>
<script type="text/javascript">

let isOwner=(parseInt(data['owner'])===parseInt(userId));
let isSystem=1*data['issystem'];
let isArchived=1*data['isarchived'];
let canWriteInProject=!isArchived && <?php try {
    echo (in_array($data['id'], session::getUpdateProjects())) ? 'true' : 'false';
} catch (BadRequestException|ServerException $e) {
    echo 'false';
} ?>;
canEdit=!isArchived && (isAdmin || isOwner);

window.addEventListener('DOMContentLoaded',function(){

    let grid=ui.grid();
    let detailsBox;
    let actionsBox;
    if(isArchived && !isSystem && isAdmin){
        detailsBox=grid.box({
            classes:'r1 c1 h2 w1',
            title:'Details'
        });
        actionsBox=grid.box({
            classes:'r3 c1 h1 w1',
            title:'Actions'
        });
        let frm=actionsBox.form({});
        frm.buttonField({
            "label":"Un-archive this project",
            "onclick":Project.unArchive
        });
    } else if(!isArchived && !isSystem && (isAdmin || isOwner)) {
        detailsBox=grid.box({
            classes:'r1 c1 h2 w1',
            title:'Details'
        });
        actionsBox=grid.box({
            classes:'r3 c1 h1 w1',
            title:'Actions'
        });
        let frm=actionsBox.form({});
        frm.buttonField({
            "label":"Archive this project",
            "onclick":Project.archive
        });
    } else {
        detailsBox=grid.box({
            classes:'r1 c1 h3 w1',
            title:'Details'
        });
    }

    if(isArchived){
        ui.infoMessageBar('This project has been archived. It cannot be changed.', detailsBox);
    }
	let frm=detailsBox.form({
		action:'/api/project/'+data['id'],
	});
	frm.textField({ label:"Name", name:'name', value:data['name'], readonly:(isArchived || isSystem || (!isAdmin &&!isOwner)) });
	frm.textField({ label:"Description", name:'description', value:data['description'], readonly:(isArchived || isSystem || (!isAdmin &&!isOwner)) });
	frm.roleField({
		readonly:isArchived || (!isAdmin && !isOwner),
		label:"Owner", 
		name:'owner', 
		otherId:data.owner, 
		otherName:data["ownername"],
		otherType:'user',
		labelField:'fullname',
		headers:['Name'],
		cellTemplates:['{{fullname}}']
	});

	//TODO better handling of long text
	if(frm.querySelector("#description")){
        frm.querySelector("#description").style.width="70%";
    }

	
	if(!isAdmin && isOwner){
		let btn=frm.querySelector("input[name=owner]").closest("label").querySelector("input[type=button]");
		btn.addEventListener("click",function(){
			alert("You can see and update this project because you are the owner. If you change the owner, "+ 
					"you may lose all rights on this project!\n\nIf you've just created the project and are "+
					"setting it up for someone else, make all your other changes before changing the project owner.");
		});
	}

	let ts=grid.tabSet({ classes:'r1 c2 h3 w2' });

	//see ../model/extensions.js
	projectExtensions.tabsBefore(ts);	

	ts.tab({
		id:'permissions', 
		label:'Permissions', 
		url:'/api/project/'+data['id']+'/permission',
		successHandler:Permission.writePermissions
	 });

    ts.filesTab();
    ts.notesTab();

	//see ../model/extensions.js
	projectExtensions.tabsAfter(ts);	
	
});

</script>
<?php include realpath(__DIR__).'/../_common/footer.php';