<?php $pageTitle='Create a user';
include realpath(__DIR__).'/../_common/header.php'; ?>
<script type="text/javascript">
window.addEventListener('DOMContentLoaded',function(){

	ui.grid();

	grid.box({ 
		classes:'r1 c2 h3 w2',
		title:'Information',
		content:'If you have an automated process that creates users, you probably don\'t want to use this form.'
	});

    const detailsBox = grid.box({
        classes: 'r1 c1 h3 w1',
        title: 'Details'
    });

    const frm = detailsBox.form({
        action: '/api/user/',
        method: 'post',
    });
    frm.textField({ label:"Username", name:'name', value:'' });
	frm.textField({ label:"Full name", name:'fullname', value:'' });
	frm.textField({ label:"Email address", name:'email', value:'' });
	//if DB Auth
	frm.passwordField({ label:"Password", name:'password', value:''});
	frm.passwordField({ label:"Enter it again", name:'password2', value:''});
	frm.createButton(checkPasswordFieldsMatch);
});

function checkPasswordFieldsMatch(){
    const field1=document.getElementById("password");
    const field2=document.getElementById("password2");
    const p1 = field1.value;
    const p2 = field2.value;
    if(""===p1 || p1!==p2){
		field1.closest("label").classList.add("invalidfield");
		field2.closest("label").classList.add("invalidfield");
		alert("Password fields are required, and must match");
		return false;
	}
    field1.closest("label").classList.remove("invalidfield");
    field2.closest("label").classList.remove("invalidfield");
	return true;
}

</script>
<?php include realpath(__DIR__).'/../_common/footer.php';