<?php
/** @var array $data The object we are going to view */
/** @noinspection PhpUnhandledExceptionInspection */
$sharedProject=project::getByName(baseproject::SHARED);
if(!$sharedProject){
	throw new NotFoundException('Could not read shared project');
}
$sharedProjectId=$sharedProject['id'];
$pageTitle='Container category: '.$data['name'];
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">

window.addEventListener('DOMContentLoaded',function(){
    const grid = ui.grid();
    const detailsBox = grid.box({
        classes: 'r1 c1 h3 w1',
        title: 'Details'
    });

    const frm = detailsBox.form({
        action: '/api/containercategory/' + data['id'],
        method: 'post',
    });
    frm.hiddenField('projectid',<?php echo $sharedProjectId; ?>);
	frm.textField({ label:"Name", name:'name' });
	frm.checkbox({
		label:'User create allowed',
		name:'userscancreate'
	});

    const ts = grid.tabSet({classes: 'r1 c2 w2 h3'});
    ts.tab({
		'label':'Container types',
		'url':'/api/containertype/containercategoryid/'+data.id+'',
		'sortby':'name',
		'sortdescending':'yes',
		'headers':['Name','Positions'],
		'cellTemplates':['<a href="/containertype/{{id}}">{{name}}</a>','{{positions}}']
	});
	ts.filesTab();
	ts.notesTab();
		
});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';
