<?php $pageTitle='Create a container type';
/** @noinspection PhpUnhandledExceptionInspection */
$sharedProject=project::getByName(baseproject::SHARED);
if(!$sharedProject){
	throw new NotFoundException('Could not read shared project');
}
$sharedProjectId=$sharedProject['id'];
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">

window.addEventListener('DOMContentLoaded',function(){
    const grid = ui.grid();
    const detailsBox = grid.box({
        classes: 'r1 c1 h3 w1',
        title: 'Details'
    });

    const frm = detailsBox.form({
        action: '/api/containertype/',
        method: 'post',
    });
    frm.hiddenField('projectid',<?php echo $sharedProjectId; ?>);
	frm.roleField({
			label:"Category", 
			name:'containercategoryid', 
			otherType:'containercategory',
			labelField:'name',
			headers:['Name'],
			cellTemplates:['{{name}}']
	});
	frm.textField({ label:"Name", name:'name', value:'' });
	frm.textField({ label:"Positions", name:'positions', value:'' });
	frm.createButton();
	
});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';
