<?php
/** @var array $data The object we are going to view */
$pageTitle='Crystal: '.$data['name'];
/** @noinspection PhpUnhandledExceptionInspection */
$sharedProject=project::getByName(baseproject::SHARED);
if(!$sharedProject){
	throw new NotFoundException('Could not read shared project');
}
$sharedProjectId=$sharedProject['id'];
$canManagePdbDepositions=(session::isAdmin() || (int)($data['projectownerid'])=== session::getUserId());
$breadcrumbs=array(
    array('url'=>'/project/'.$data['projectid'], 'icon'=>'project', 'help'=>'Go to this plate\'s project'),
    array('url'=>'/plate/'.$data['plateid'], 'icon'=>'plate', 'help'=>'Go to this plate')
);
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">
//let canManagePdbDepositions=<?php echo $canManagePdbDepositions ? 'true' : 'false '; ?>;
let canManagePdbDepositions=canEdit;

window.addEventListener('DOMContentLoaded',function(){
	let grid=ui.grid();
	let detailsBox=grid.box({
		id:'crystaldetails',
		classes:'r1 c1 h3 w1',
		title:'Crystal'
	});

    ui.archivedProjectMessageBar(detailsBox);

	detailsBox.innerHTML+='<div id="dropimage" style="position:relative"><img alt="Crystal drop" src="/api/dropimagefile/'+data.dropimageid+'/full.jpg" style="width:100%" /></div>';

	new AjaxUtils.Request('/api/dropimage/'+data.dropimageid, {
		method:'get',
		onFailure:function(transport){ /* meh */},
		onSuccess:function(transport){
			let di=document.getElementById("dropimage").querySelector("img");
            di.dropImage=transport.responseJSON;
            let xh=Crystal.drawCrosshair(data, di, true);
            xh.style.display="block";
            xh.style.cursor="auto";
            xh.querySelectorAll("div").forEach(function(div){
                div.style.cursor="auto";
            });
        }
	});
	
	let frm=detailsBox.form({
		action:'/api/crystal/'+data['id'],
		method:'patch',
	});
	let wellDropName=data["welldropname"].split('_')[1];
	let dropNumber=data.numberindrop;
	frm.formField({ readOnly:true, label:"&nbsp;", content:`<a href="/imagingsession/${data["imagingsessionid"]}#${wellDropName}c${dropNumber}">Show in drop viewer</a>` });
    frm.starRatingField();
    frm.formField({ readOnly:true, label:"Plate", content:'<a href="/plate/'+data["plateid"]+'">'+data["platename"]+'</a>' });
    frm.formField({ readOnly:true, label:"Well and drop", content:wellDropName.replace("."," drop ") });
    new AjaxUtils.Request("/api/plate/"+data.plateid,{
        method:"get",
        onFailure:function(){/* meh */},
        onSuccess:function(transport){
            let plate=transport.responseJSON;
            if(""!==plate.screenid){
                new AjaxUtils.Request("/api/screen/"+plate.screenid,{
                    method:"get",
                    onFailure:function(){/* meh */},
                    onSuccess:function(transport){
                        let screen=transport.responseJSON;
                        new AjaxUtils.Request("/api/screen/"+plate.screenid+"/screencondition?all=1",{
                            method:"get",
                            onFailure:function(){/* meh */},
                            onSuccess:function(transport){
                                let conditions=transport.responseJSON.rows;
                                let plateRow=parseInt(data.row);
                                let plateCol=parseInt(data.col);
                                conditions.forEach(function(c){
                                    let conditionRow=parseInt(c.row);
                                    let conditionCol=parseInt(c.col);
                                    if(plateRow===conditionRow && plateCol===conditionCol){
                                        if(1===parseInt(screen["isstandard"])){
                                            frm.formField({ readOnly:true, label:"Screen", content:screen.name });
                                        }
                                        frm.formField({ readOnly:true, label:"Condition", content:c.description });
                                    }
                                });
                            }
                        });
                    }
                });
            }
        }
    });

	let ts=grid.tabSet({ classes:'r1 c2 w2 h3' });
	Crystal.renderProteinTab(data,ts);
    Dataset.listTab(ts, 'crystalid', data["id"]);
	ts.filesTab();
	ts.notesTab();

});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';