<?php
/** @var array $data The object we are going to view */
$pageTitle='Crystal scoring system: '.$data['name'];
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">
window.addEventListener('DOMContentLoaded',function(){

	let grid=ui.grid();

	const ts=grid.tabSet({ classes:"r1 c1 h3 w3"});

	let headerTemplates=['Index','Colour','Label'];
	let cellTemplates=[ '{{scoreindex}}','<div style="display:inline-block;width:3em;background:#'+'{{color}}">&nbsp;</div>','<a href="/crystalscore/{{id}}">{{label}}</a>' ];
	let scores=ts.tab({
		label:'Scores',
		url:'/api/crystalscoringsystem/'+data['id']+'/score?sortby=scoreindex&sortdescending=true',
		headers:headerTemplates,
		cellTemplates:cellTemplates
	});

    headerTemplates=["Barcode"];
    cellTemplates=['<a href="/plate/{{id}}">{{name}}</a>']
    ts.tab({
        label:'Plates',
        url:'/api/plate/crystalscoringsystemid/'+data['id']+'sortby=id&sortdescending=true',
        headers:headerTemplates,
        cellTemplates:cellTemplates
    });

    ui.selectTab(scores);

});

</script>
<?php 
include realpath(__DIR__).'/../../core/_common/footer.php';