<?php
/** @var array $data The object we are going to view */
/** @var array $wwwroot The document root */

$hasConfig=true;
$pageTitle='Drop viewer: Plate <a style=\"float:none\" href=\"/plate/'.$data['plateid'].'\">'.$data['platename'].'</a> drop <span id=\"dropname\">?</span>';
$breadcrumbs=array(
		array('url'=>'/project/'.$data['projectid'], 'icon'=>'project', 'help'=>'Go to this plate\'s project'),
		array('url'=>'/plate/'.$data['plateid'], 'icon'=>'plate', 'help'=>'Go to this plate')
);

include realpath(__DIR__).'/../../core/_common/header.php'; ?>

<script type="text/javascript" src="<?php echo '/js/model/dropviewer/dropviewer.js?t='.@filemtime($wwwroot.'/client/js/model/dropviewer/dropviewer.js'); ?>"></script>
<script type="text/javascript" src="<?php echo '/js/model/dropviewer/dropviewer_keymappings.js?t='.@filemtime($wwwroot.'/client/js/model/dropviewer/dropviewer_keymappings.js'); ?>"></script>
<script type="text/javascript">
let canUpdate=<?php /** @noinspection PhpUnhandledExceptionInspection */echo !$data['isarchived'] && (
		//Can update if admin, plate owner, or inherits update permissions via group membership
		session::isAdmin()
		|| session::getUserId()==$data['plateownerid']
		|| in_array($data['projectid'], session::getUpdateProjects())
	) ? 'true' : 'false' ;?>;
let canDeleteCrystals=<?php /** @noinspection PhpUnhandledExceptionInspection */echo !$data['isarchived'] && (
			//Can delete if admin, plate owner, or inherits update permissions via group membership
			// - other code will enforce "if not fished" condition
			session::isAdmin()
			|| session::getUserId()==$data['plateownerid']
			|| in_array($data['projectid'], session::getDeleteProjects())			
		) ? 'true' : 'false' ;?>;

window.addEventListener("load",function(){
	document.documentElement.style.overflow="hidden"; // <html> tag
	document.body.style.background="black";
	document.getElementById("container").style.background="black";
	document.body.style.overflow="hidden";
	document.getElementById("headersearch").blur();
	document.getElementById("configbutton").addEventListener("click", togglePageConfig);
	document.getElementById("content").classList.add("dropviewer");
	// if(!ui.isSmallScreen){
		//DropViewer.preCacheMovieImages();
        DropViewer.init();
		KeyboardShortcuts.init();
	// } else {
	// 	SmallScreenDropViewer.init();
	// }
});
window.addEventListener("resize",function(){
	Measure.setScale();
	DropViewer.getScoringSystem();
	if(ui.smallScreenThresholdCrossed()){
		ui.forceReload();
		return false;
	}
	if(ui.isSmallScreen){
		SmallScreenDropViewer.renderControls();
	}
});
</script>

<div id="imagepane">
	<img id="currentimage" class="dropimage"  alt="" src=""/>
	<div id="dv_measure" style="display:none">
		<div id="dv_nomeasure">No scale information available</div>
		<div id="dv_cross"><div id="dv_crossx"></div><div id="dv_crossy"></div></div>
		<div id="ring1000"><span>1000&#181;m</span><span>1000&#181;m</span></div>
		<div id="ring900"></div>
		<div id="ring800"><span>800</span><span>800</span></div>
		<div id="ring700"></div>
		<div id="ring600"><span>600</span><span>600</span></div>
		<div id="ring500"></div>
		<div id="ring400"><span>400</span><span>400</span></div>
		<div id="ring300"></div>
		<div id="ring200"><span>200</span><span>200</span></div>
		<div id="ring180" class="dv_smallmeasure"></div>
		<div id="ring160" class="dv_smallmeasure"></div>
		<div id="ring140" class="dv_smallmeasure"></div>
		<div id="ring120" class="dv_smallmeasure"></div>
		<div id="ring100"></div>
		<div id="ring80" class="dv_smallmeasure"></div>
		<div id="ring60" class="dv_smallmeasure"></div>
		<div id="ring40" class="dv_smallmeasure"></div>
		<div id="ring20" class="dv_smallmeasure"></div>
	</div>
</div>
<div id="controls">
    <div class="controlpanel" id="loadingpanel">
        <p style="margin-top: 5em">Pre-loading images...</p>
        <div style="margin:1em 10%;position:relative;background-color:#ccc;height:0.75em;">
            <div id="cachebar" style="position:absolute;top:0;bottom:0;left:0;width:0;background-color:#33f;"></div>
            </div>
        <div id="imagecache" style="overflow:hidden">&nbsp;</div>
    </div>
	<div class="controlpanel" id="dropviewerpanel">
		<div title="Playback speed" class="delayslider">Image delay:
			<span id="dv_delayless" onclick="DropViewer.decreaseMovieDelay(this);return false;">0.5s</span>
            <!--suppress HtmlFormInputWithoutLabel -->
            <input type="range" min="0.5" max="2" value="0.8" step="0.1" class="slider" id="dv_delay" onchange="DropViewer.setMovieDelay(this);return false;" />
			<span id="dv_delaymore" onclick="DropViewer.increaseMovieDelay(this);return false;">2s</span>
        </div>
		<div id="dv_moviecontrols">
			<span id="dv_first" title="First drop" onclick="DropViewer.goToFirst()">First</span>
			<span id="dv_prev" title="Previous drop" onclick="DropViewer.goToPrevious(true)">Prev</span>
			<span id="dv_playstop" title="Play" onclick="DropViewer.playOrStop()">Play</span>
			<span id="dv_next" title="Next drop" onclick="DropViewer.goToNext(true)">Next</span>
			<span id="dv_last" title="Last drop" onclick="DropViewer.goToLast()">Last</span>
			<span id="dv_nav" title="Navigation..." onclick="DropNav.open()">Nav</span>
		</div>
		<div id="dv_scores">Waiting for scores...</div>
		<div id="dv_timecourseends">
			<div style="font-weight:bold">First and latest images</div>
			<img id="dv_timecoursefirst" alt="" src=""/>
			<img id="dv_timecourselast" alt="" src=""/>
		</div>
	</div>

	<div class="controlpanel" id="timecoursepanel">
		<div title="Playback speed" class="delayslider">Image delay:
			<span id="tc_delayless" onclick="DropViewer.decreaseMovieDelay(this);return false;">0.5s</span>
            <!--suppress HtmlFormInputWithoutLabel -->
            <input type="range" min="0.5" max="2" value="0.8" step="0.1" class="slider" id="tc_delay" onchange="DropViewer.setMovieDelay(this);return false;" />
            <span id="tc_delaymore" onclick="DropViewer.increaseMovieDelay(this);return false;">2s</span>
		</div>
		<div id="tc_moviecontrols">
			<span id="tc_first" title="First image" onclick="TimeCourse.goToFirst()">First</span>
			<span id="tc_prev" title="Previous image" onclick="TimeCourse.goToPrevious()">Prev</span>
			<span id="tc_playstop" title="Play" onclick="TimeCourse.playOrStop()">Play</span>
			<span id="tc_next" title="Next image" onclick="TimeCourse.goToNext()">Next</span>
			<span id="tc_last" title="Last image" onclick="TimeCourse.goToLast()">Last</span>
			<span id="tc_nav" title="Navigation..." onclick="DropNav.open()">Nav</span>
		</div>
		<div id="tc_lighttypes"></div>
		<div id="tc_images"></div>
	</div>


	<div class="controlpanel" id="dropinfopanel">
	Drop info here
	</div>

	<div class="controlpanel" id="selectpanel">
	Waiting for list of crystals...
	</div>

	<div id="viewswitcher">
		<div id="viewbutton_dv" onclick="switchPanels(this)" title="Measure and score" class="viewbutton current">
            <!--suppress HtmlUnknownTarget --><img src="/images/icons/dropviewer/viewbuttons/viewbutton_dv_current.png" alt="" />
        </div><div id="viewbutton_tc" onclick="switchPanels(this)" title="Drop imaging history" class="viewbutton">
            <!--suppress HtmlUnknownTarget --><img src="/images/icons/dropviewer/viewbuttons/viewbutton_tc.png" alt="" />
        </div><div id="viewbutton_di" onclick="switchPanels(this)" title="Drop and plate information" class="viewbutton">
            <!--suppress HtmlUnknownTarget --><img src="/images/icons/dropviewer/viewbuttons/viewbutton_di.png" alt="" />
        </div><div id="viewbutton_xs" onclick="switchPanels(this)" title="Crystal selection" class="viewbutton">
            <!--suppress HtmlUnknownTarget --><img src="/images/icons/dropviewer/viewbuttons/viewbutton_xs.png" alt="" />
        </div><div id="viewbutton_dn" onclick="DropNav.open()" title="Drop navigation" class="viewbutton">
            <!--suppress HtmlUnknownTarget --><img src="/images/icons/dropviewer/viewbuttons/viewbutton_dn.png" alt="" />
        </div>
	</div>

</div>

<?php include realpath(__DIR__).'/../../core/_common/footer.php';
