<?php
try {
    $scoringSystems=crystalscoringsystem::getAll();
    //Actually catch, don't suppress here. There may genuinely be no scoring systems in a new installation.
} catch (BadRequestException|ServerException|NotFoundException $e) {
    $scoringSystems=null;
}
$scoringSystems=$scoringSystems['rows'];

$pageTitle='Create a plate';
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">
const scoringSystems=<?php echo json_encode($scoringSystems); ?>;

window.addEventListener('DOMContentLoaded',function(){

	const grid=ui.grid();

    if(!scoringSystems){
        grid.box({
            classes:'r1 c2 h1 w1',
            title:'Cannot create plates',
            content:'You cannot create plates because no scoring system has been set up. Talk to your administrator.'
        });
        return;
    }

	grid.box({ 
		classes:'r1 c2 h3 w2',
		title:'Plates',
		content:'If you have an automatic imaging system, you probably don\'t need to do this.'
	});

    const detailsBox = grid.box({
        classes: 'r1 c1 h3 w1',
        title: 'Details'
    });

    const frm = detailsBox.form({
        action: '/api/plate/',
        method: 'post',
    });
    frm.hiddenField("ownerid",userId);
	frm.textField({ label:"Barcode", name:'name', value:'' });
	frm.roleField({ 
		label:"Project", 
		name:'projectid',
		otherType:'project',
		labelField:'name',
		headers:['Name', 'Description'],
		cellTemplates:['{{name}}','{{description}}']
	});
	frm.roleField({ 
		label:"Plate type", 
		name:'platetypeid', 
		otherType:'platetype',
		labelField:'name',
		headers:['Name', 'Geometry'],
		cellTemplates:['{{name}}','{{rows}}x{{cols}}, {{subs}}-drop']
	});

	if(scoringSystems.length>1){
		frm.roleField({ 
			label:"Scoring system", 
			name:'crystalscoringsystemid', 
			otherType:'crystalscoringsystem',
			labelField:'name',
			headers:['Name'],
			cellTemplates:['{{name}}']
		});
		frm.createButton();
	} else {
		frm.createButton();
		frm.hiddenField("crystalscoringsystemid",scoringSystems[0]['id']);
	}
});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';