<?php $pageTitle='Create a standard screen';
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">
let canCreate=<?php /** @noinspection PhpUnhandledExceptionInspection */ echo screen::canCreateStandardScreens() ? 'true' : 'false' ; ?>;

window.addEventListener('DOMContentLoaded',function(){

	let grid=ui.grid();

	if(!canCreate){ 
		grid.box({ 
			classes:'r1 c2 h1 w1',
			title:'Cannot create',
			content:'You cannot create standard screens because you do not have create permissions in the "Shared" project.'
		});
		return;
	}

    let fileBox=grid.box({
        classes:'r1 c3 h1 w1',
        title:'Create screen from file'
    });

    let fileForm=fileBox.form({
        action:'/api/screen/',
        method:'post',
    });
    fileForm.hiddenField("isstandard","1");
    fileForm.fileField({ label:"Screen file", name:'file' });
    fileForm.createButton({
        tabAfterCreate:'conditions'
    });

    let detailsBox=grid.box({
        classes:'r2 c3 h2 w1',
        title:'Create screen without a file'
    });

    let detailsForm=detailsBox.form({
        action:'/api/screen/',
        method:'post',
    });
    detailsForm.hiddenField("isstandard","1");
    detailsForm.textField({ label:"Name", name:'name', value:'' });
    detailsForm.textField({ label:"Manufacturer", name:'manufacturer', value:'' });
    detailsForm.textField({ label:"Catalogue number", name:'catalognumber', value:'' });
    detailsForm.textField({ label:"Number of rows", name:'rows', value:'8' });
    detailsForm.textField({ label:"Number of columns", name:'cols', value:'12' });
    detailsForm.createButton({
        tabAfterCreate:'conditions'
    });

    grid.box({
        classes:'r1 c1 h3 w1',
        title:'Screen definition files',
        content:'<div class="tabhelp">'+
            '<p>You can upload a file describing your standard screen.</p>' +
            '<p>Screen files must have exactly 96 conditions (8 rows by 12 columns). If your screen has different dimensions, or if your file is not recognised, create it manually.</p>'+
            '<h3 style="clear:both;margin-top:1.5em">Screen formats:</h3>'+
            '<p>IceBear understands the following screen file formats:</p>'+
            '<ul style="padding-left:1.5em">'+
            '<li><strong>Two-column CSV:</strong> A simple file with well number and description. You can use this <a href="/resources/WellAndCondition.csv">Template CSV file</a>;</li>'+
            '<li><strong>Mimer:</strong> The output from Mimer*, saved as CSV (not Excel format);</li>'+
            '<li><strong>Rock Maker XML:</strong> A screen XML file in Rock Maker XML format. Formulatrix has a <a target="_blank" href="https://formulatrix.com/protein-crystallization-systems/rock-maker-crystallization-software/#pp-accord-5f1ef46879a47-1">library of standard screens</a> available for download in this format.</li>'+
            '<li><strong>Tecan CrysScreen:</strong> The Microsoft Word document generated by the Tecan robot can be uploaded directly into IceBear; or</li>'+
            '<li><strong>Rigaku CrystalTrak:</strong> A plate or screen XML file generated by CrystalTrak.</li>'+
            '</ul>'+
            '<hr style="clear:both;margin-top:1.5em;margin-bottom:1.5em"/>'+
                '<p><span style="font-size:80%">* Mimer: an automated spreadsheet-based crystallization screening system. Brodersen DE, Andersen GR, Andersen CB<br/>'+
            '<span style="color:transparent">* </span>Acta Cryst F, 2013 (69) pp815-820. <a target="_blank" href="https://www.ncbi.nlm.nih.gov/pubmed/?term=PMID%3A+23832216">PubMed PMID:23832216</a></span></p>'+
            '</div>'
    });

    let fxBox=grid.box({
        classes:'r1 c2 h3 w1',
        title:'Install screen from Formulatrix&reg; Screen Library',
        content:'Getting list of screens...'
    })

    CrystallizationScreen.getRockMakerLibraryScreens(fxBox);

});


</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';