<?php
/** @var array $data The object we are going to view */
$pageTitle='Screen: '.$data['name'];
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">

window.addEventListener('DOMContentLoaded',function(){
	let grid=ui.grid();

	let detailsClasses='r1 c1 h3 w1';
    if((isAdmin || isTechnician) && parseInt(data["isstandard"])){
        detailsClasses='r1 c1 h2 w1';
    }

	let detailsBox=grid.box({
		classes:detailsClasses,
		title:'Basic details'
	});

    ui.archivedProjectMessageBar(detailsBox);

	let detailsForm=detailsBox.form({
		action:'/api/screen/'+data.id,
		method:'patch',
	});
	let bar=ui.warningMessageBar("This screen is not available for use.");
	bar.id="unavailablewarning";
	detailsForm.appendChild(bar);
	CrystallizationScreen.setUnavailableWarningVisibility();

	detailsForm.textField({ label:"Name", name:'name' });
	detailsForm.textField({ label:"Manufacturer", name:'manufacturer' });
	detailsForm.textField({ label:"Catalogue number", name:'catalognumber' });

    CrystallizationScreen.renderActionsBox();

    let headers = ['Well number', 'Description'];
    let cellTemplates = ['{{wellnumber}}', [CrystallizationScreen.getConditionCell, 'description']];
    let ts = grid.tabSet({classes: 'r1 c2 w2 h3'});
    let contentBefore=null;
    if("1"===data["isstandard"] && canEdit){
        contentBefore=ui.warningMessageBar("Changing these conditions will affect all plates using this screen.").outerHTML
    }
    ts.tab({
		'label':'Conditions',
		'id':'conditions',
		'url':'/api/screen/'+data.id+'/screencondition',
		'getAll':1,
		'headers':headers,
		'cellTemplates':cellTemplates,
        contentBefore:contentBefore
	});
	ts.tab({
		'label':'Plates using this screen',
		'url':'/api/plate/screenid/'+data.id+'',
		'sortby':'name',
		'sortdescending':'yes',
		'headers':['Plate','Project'],
		'cellTemplates':['<a href="/plate/{{id}}">{{name}}</a>',[Project.getLink,'name'] ]
	});
	ts.filesTab();
	ts.notesTab();

	CrystallizationScreen.adjustConditionsTableForEdit();


});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';
