<?php
/** @var array $data The object we are going to view */
$pageTitle='Sequence: '.$data['name'];
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">

window.addEventListener('DOMContentLoaded',function(){
    const grid = ui.grid();

    grid.box({
		classes:'r1 c1 h1 w1',
		content:'This is only for testing and development. Go to the project page for a better way to work with proteins, constructs and sequences.'
	});

    const detailsBox = grid.box({
        classes: 'r2 c1 h2 w1',
        title: 'Details'
    });
    const frm = detailsBox.form({
        action: '/api/construct/' + data['id'],
        method: 'patch',
    });
    frm.textField({ label:"Name", name:'name', value:data['name'] });
	frm.textField({ label:"DNA Sequence", name:'dnasequence', value:'' });
	frm.roleField({ 
		label:"Construct",
		name:'constructid', 
		otherType:'construct',
		//constraint:{ 'owner':userId },
		labelField:'name',
		headers:['Name','Project'],
		cellTemplates:['{{name}}','{{projectname}}']
	});
	
});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';
