<?php $pageTitle='Create a shipment';
/** @var array $data The object we are going to view */
/** @noinspection PhpUnhandledExceptionInspection */
$sharedProject=project::getByName(baseproject::SHARED);
if(!$sharedProject){
	throw new NotFoundException('Could not read shared project');
}
$sharedProjectId=$sharedProject['id'];
/** @noinspection PhpUnhandledExceptionInspection */
$canCreateShipments=session::isAdmin() || usergroup::userisingroup(usergroup::SHIPPERS);
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">

window.addEventListener('DOMContentLoaded',function(){
    const grid = ui.grid();
    const detailsBox = grid.box({
        classes: 'r1 c1 h3 w1',
        title: 'Details'
    });
    const frm = detailsBox.form({
        action: '/api/shipment/',
        method: 'post',
    });
    frm.hiddenField('projectid',<?php echo $sharedProjectId; ?>);
    <?php if(isset($_GET['dewars'])){ ?>
        frm.hiddenField('dewarbarcodes',"<?php echo $_GET['dewars']; ?>");
        frm.formField ({
            'label':'Dewars',
            'content':'<?php echo implode('<br/>', explode(',', $_GET['dewars'])); ?>'
        });
    <?php } else { ?>
        frm.hiddenField('dewarbarcodes',"");
    <?php } ?>
	frm.textField({ label:"Shipment name", name:'name', value:'' });
	frm.roleField({ 
		label:"Destination", 
		name:'shipmentdestinationid', 
		otherType:'shipmentdestination',
        constraint:{"isavailable":"1"},
		labelField:'name',
		headers:['Name'],
		cellTemplates:['{{name}}']
	});
	frm.createButton();

    grid.box({
        classes:'r1 c2 h3 w2',
        title:'Automated shipment submission',
        content:'<p>IceBear currently supports automated shipment data submission to MAX-IV, ESRF and Diamond Light Source.</p>'+
                '<p>For other synchrotrons, you will need to submit the shipment data manually using the '+
                'synchrotron\'s own systems. You can still use IceBear to record data collection notes and '+
                'manage the unpacking of returned dewars.</p>'
    });

});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';