<?php

use PHPUnit\Framework\TestCase;

class validatorTest extends TestCase {

    /**
     * @throws ServerException
     */
    public function testValidGeofences(){
        $strings=array(
            //no geofence
            '',
            null,
            //circular geofence - lat,long,radius
            '0,0,1',
            '90,0,1',
            '-90,0,1',
            '90,180,1',
            '-90,-180,1',
            '-54,123.45678,29.3',
            //polygonal geofence - minimum of three lat/long pairs
            '0,0,10,0,10,10',
            '0,0,10,0,10,10,-10,10'
        );
        foreach ($strings as $string){
            $this->assertTrue(validator::isValid($string, validator::GEOFENCE), "'$string' is a valid geofence but failed validation");
        }
    }

    /**
     * @throws ServerException
     */
    public function testInvalidGeofences(){
        $strings=array(
            'fsz-j;fo', //garbage
            'fs,z-j;,fo', //garbage that will split into 3 parts (looks like circular geofence)
            'f,s,z-,j;,f,o', //garbage that will split into 6 parts (looks like triangular geofence)
            '0,0,10,0,10,10,-10,10,', //trailing comma
            ',,', //just commas
            ',,,,,', //just commas
            '0,0,0', //bad radius
            '0,0,-10', //bad radius
            '91,0,1', //bad latitude
            '-91,0,1', //bad latitude
            '90,181,1', //bad longitude
            '-90,-181,1', //bad longitude
            '-164,123.45678,29.3', //bad latitude
            '10,0', //only one lat/long pair
            '0,0,10,0', //only two lat/long pairs
            '0,0,10,0,10,10,10', //odd number of elements, not complete lat/long pairs
            '-120,0,10,0,10,10', //bad lat
            '0,200,10,0,10,10' //bad long
        );
        foreach ($strings as $string){
            $this->assertFalse(validator::isValid($string, validator::GEOFENCE), "'$string' is not a valid geofence but passed validation");
        }
    }

	public function testJSONValidation(){
		self::assertTrue(validator::isValid('{"foo":"bar"}', validator::JSON));
		self::assertFalse(validator::isValid('{"foo":"bar":"baz"}', validator::JSON));
	}

}