<?php

include_once 'DeviceTest.php';

class ImageScoringTest extends DeviceTest {

    /**
     * @throws ServerException
     * @throws NotFoundException
     * @throws BadRequestException
     */
    public function testGetScoresWithScoringSystemName(){
        $scores=ImageScoring::getScoresWithScoringSystemName(['name'=>FormulatrixImport::SCORING_SYSTEM_NAME]);
        self::assertCount(10, $scores);
        self::assertArrayHasKey("id", $scores[0]);
        self::assertArrayHasKey("label", $scores[0]);
        self::assertArrayHasKey("color", $scores[0]);
        self::assertArrayHasKey("hotkey", $scores[0]);
        self::assertArrayHasKey("scoreindex", $scores[0]);
    }

    /**
     * @throws ServerException
     * @throws NotFoundException
     * @throws BadRequestException
     */
    public function testGetScoringSystem(){
        $scoringSystem=ImageScoring::getScoringSystem(['name'=>FormulatrixImport::SCORING_SYSTEM_NAME]);
        self::assertArrayHasKey('name',$scoringSystem);
        self::assertArrayHasKey('scores',$scoringSystem);
        $scores=$scoringSystem['scores'];
        self::assertCount(10, $scores);
        self::assertArrayHasKey("id", $scores[0]);
        self::assertArrayHasKey("label", $scores[0]);
        self::assertArrayHasKey("color", $scores[0]);
        self::assertArrayHasKey("hotkey", $scores[0]);
        self::assertArrayHasKey("scoreindex", $scores[0]);
    }

    /**
     * @throws ServerException
     * @throws NotFoundException
     * @throws BadRequestException
     */
    public function testGetScoringSystemByNameString(){
        $scoringSystem=ImageScoring::getScoringSystem(FormulatrixImport::SCORING_SYSTEM_NAME);
        self::assertArrayHasKey('name',$scoringSystem);
        self::assertArrayHasKey('scores',$scoringSystem);
        $scores=$scoringSystem['scores'];
        self::assertCount(10, $scores);
        self::assertArrayHasKey("id", $scores[0]);
        self::assertArrayHasKey("label", $scores[0]);
        self::assertArrayHasKey("color", $scores[0]);
        self::assertArrayHasKey("hotkey", $scores[0]);
        self::assertArrayHasKey("scoreindex", $scores[0]);
    }

    /**
     * @throws ServerException
     * @throws NotFoundException
     * @throws BadRequestException
     */
    public function testGetScoringSystemById(){
        $scoringSystem=crystalscoringsystem::getByName(FormulatrixImport::SCORING_SYSTEM_NAME);
        if(!$scoringSystem){ self::fail('No scoring system called '.FormulatrixImport::SCORING_SYSTEM_NAME); }
        $scoringSystem=ImageScoring::getScoringSystem($scoringSystem['id']);
        self::assertArrayHasKey('name',$scoringSystem);
        self::assertArrayHasKey('scores',$scoringSystem);
        $scores=$scoringSystem['scores'];
        self::assertCount(10, $scores);
        self::assertArrayHasKey("id", $scores[0]);
        self::assertArrayHasKey("label", $scores[0]);
        self::assertArrayHasKey("color", $scores[0]);
        self::assertArrayHasKey("hotkey", $scores[0]);
        self::assertArrayHasKey("scoreindex", $scores[0]);
    }

    /**
     * @return void
     * @throws BadRequestException
     * @throws ForbiddenException
     * @throws NotFoundException
     * @throws ServerException
     */
    public function testCreateScoringSystem(){
        $scoringSystem=[
            'name'=>'Test'.time(),
            'scores'=>[
                [
                    'name'=>'Crystals',
                    'color'=>'-65536',
                    'hotkey'=>'9',
                    'index'=>'9'
                ]
            ]
        ];
        $created=ImageScoring::createScoringSystem($scoringSystem);
        self::assertEquals($scoringSystem['name'], $created['name']);
        self::assertArrayHasKey('scores', $created);
        self::assertEquals('ff0000',$created['scores'][0]['color']);
    }

}