<?php /** @noinspection PhpUnhandledExceptionInspection */
/**
 * Upgrades the database from version 1.10.1 to version 1.10.2
 * DO NOT call this directly, it will fail.
 * To be included from classes/core/updater.class.php.
 * Assumes that logging has already been init()ed. Log class will throw ServerException if not.
 */
Log::write(Log::LOGLEVEL_INFO, "In updater, from 1.10.1 to 1.10.2...");

Log::write(Log::LOGLEVEL_INFO, "Adding uuid columns to various tables...");
$tables=[
	'beamline',
	'construct',
	'container',
	'crystal',
	'dataset',
	'dropimage',
	'imager',
	'imagingsession',
	'plate',
	'platetype',
	'platewell',
	'protein',
	'screen',
	'screencondition',
	'sequence',
	'shipment',
	'user'
];
foreach($tables as $table) {
	Log::write(Log::LOGLEVEL_INFO, "Adding uuid column to $table...");
	database::addOrAlterColumn($table,'uuid','CHAR(40)');
}

Log::write(Log::LOGLEVEL_INFO, "...update done");
