<?php
/**
 * Upgrades the database from version 1.2.2 to version 1.2.3.
 * DO NOT call this directly, it will fail.
 * To be included from classes/core/updater.class.php.
 * Assumes that logging has already been init()ed. Log class will throw ServerException if not.
 */

$tables=array();
$result=database::queryGetAll('SHOW TABLES');
foreach($result['rows'] as $row){
    foreach($row as $k=>$v){
        $tables[]=$v;
    }
}

/*
if(in_array('testtable', $tables)){
    Log::write(Log::LOGLEVEL_INFO, "Test table testtable already exists");
} else {
    Log::write(Log::LOGLEVEL_INFO, "Creating test table testtable...");
    database::query("
        CREATE TABLE IF NOT EXISTS testtable (
        id bigint(20) unsigned NOT NULL,
        name varchar(250) COLLATE utf8_bin NOT NULL,
        UNIQUE KEY id (id),
        UNIQUE KEY name (name)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='Test table';
    ");    
    Log::write(Log::LOGLEVEL_INFO, "Created test table.");
}
*/

if(in_array('skin', $tables)){
    Log::write(Log::LOGLEVEL_INFO, "Table 'skin' already exists");
} else {
    Log::write(Log::LOGLEVEL_INFO, "Creating table 'skin'...");
    database::query("
        CREATE TABLE IF NOT EXISTS `skin` (
            `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
            `name` varchar(50) COLLATE utf8_bin NOT NULL,
            `friendlyname` varchar(50) COLLATE utf8_bin NOT NULL,
            `description` varchar(250) COLLATE utf8_bin NOT NULL,
            `navbaricontheme` enum('lighticons','darkicons') COLLATE utf8_bin NOT NULL DEFAULT 'darkicons',
            `boxheadericontheme` enum('lighticons','darkicons') COLLATE utf8_bin NOT NULL DEFAULT 'darkicons',
            `treeheadericontheme` enum('lighticons','darkicons') COLLATE utf8_bin NOT NULL DEFAULT 'lighticons',
            `bodyicontheme` enum('lighticons','darkicons') COLLATE utf8_bin NOT NULL DEFAULT 'darkicons',
            PRIMARY KEY (`id`),
            UNIQUE KEY `name` (`name`)
        ) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1;
    ");
    Log::write(Log::LOGLEVEL_INFO, "Created skin table. Adding default skin...");
    database::query("INSERT INTO `skin` 
        (`id`, `name`, `friendlyname`, `description`, `navbaricontheme`, `boxheadericontheme`, `treeheadericontheme`, `bodyicontheme`) VALUES
        (1, 'default', 'Default', 'The default IceBear look.', 'darkicons', 'darkicons', 'lighticons', 'darkicons');
    ");
    Log::write(Log::LOGLEVEL_INFO, "...done.");

}

Log::write(Log::LOGLEVEL_INFO, "Changing manifest column of shipment table from text to mediumtext...");
database::addOrAlterColumn('shipment', 'manifest', 'MEDIUMTEXT CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL');
Log::write(Log::LOGLEVEL_INFO, "...done.");

Log::write(Log::LOGLEVEL_INFO, "Adding actiononreturn column to diffractionrequest...");
database::addOrAlterColumn('diffractionrequest', 'actiononreturn', 'VARCHAR(20) NULL');
Log::write(Log::LOGLEVEL_INFO, "...done.");

Log::write(Log::LOGLEVEL_INFO, "Adding default value to diffractionrequest comment column...");
database::addOrAlterColumn('diffractionrequest', 'comment', 'VARCHAR(250) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT ""');
Log::write(Log::LOGLEVEL_INFO, "...done.");

Log::write(Log::LOGLEVEL_INFO, "Adding proposalname column to shipment...");
database::addOrAlterColumn('shipment', 'proposalname', 'VARCHAR(30) NULL');
Log::write(Log::LOGLEVEL_INFO, "...done.");

Log::write(Log::LOGLEVEL_INFO, "Adding sessionname column to shipment...");
database::addOrAlterColumn('shipment', 'sessionname', 'VARCHAR(30) NULL');
Log::write(Log::LOGLEVEL_INFO, "...done.");

Log::write(Log::LOGLEVEL_INFO, "Setting some project permissions...");
$sharedProjectId=project::getSharedProjectId();
$techniciansGroup=usergroup::getByName(usergroup::TECHNICIANS);
$shippersGroup=usergroup::getByName(usergroup::SHIPPERS);
$permissions=array(
    array($sharedProjectId, $techniciansGroup, 'read'),
    array($sharedProjectId, $techniciansGroup, 'create'),
    array($sharedProjectId, $techniciansGroup, 'update'),
    array($sharedProjectId, $techniciansGroup, 'delete'),
    array($sharedProjectId, $shippersGroup, 'read'),
    array($sharedProjectId, $shippersGroup, 'create'),
    array($sharedProjectId, $shippersGroup, 'update'),
    array($sharedProjectId, $shippersGroup, 'delete'),
);
foreach ($permissions as $p) {
    try {
        Log::write(Log::LOGLEVEL_DEBUG, 'projectid:'.$p[0].', usergroupid:'.$p[1]['id'].', type:'.$p[2]);
        permission::create(array('projectid'=>$p[0], 'usergroupid'=>$p[1]['id'], 'type'=>$p[2]));
    } catch (BadRequestException $e){
        //Permission already exists
    }
}
Log::write(Log::LOGLEVEL_INFO, "...done.");
