<?php
/**
 * Upgrades the database from version 1.7.1 to version 1.7.2
 * DO NOT call this directly, it will fail.
 * To be included from classes/core/updater.class.php.
 * Assumes that logging has already been init()ed. Log class will throw ServerException if not.
 */

//In importer, if config item does not exist, create it and set it TRUE.
//Warn in update that this has been done.

Log::write(Log::LOGLEVEL_INFO, "In updater, from 1.7.1 to 1.7.2");
Log::write(Log::LOGLEVEL_INFO, "Setting default value for protein.proteinacronym");
database::query("ALTER TABLE `protein` CHANGE `proteinacronym` `proteinacronym` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '';");
Log::write(Log::LOGLEVEL_INFO, "...done");

if(null===config::get('rigaku_micronsperpixel')){
    Log::write(Log::LOGLEVEL_INFO, "Adding microns per pixel config item for Rigaku imagers");
    database::query("INSERT INTO `config` (`name`, `description`, `type`, `enumvalues`, `minimum`, `maximum`, `defaultvalue`, `value`) 
        VALUES ('rigaku_micronsperpixel', 'Fixed scale in microns per pixel', 'float', NULL, '0.001', NULL, '-1', '-1');");
    Log::write(Log::LOGLEVEL_INFO, "...done");
} else {
    Log::write(Log::LOGLEVEL_INFO, "Not adding microns per pixel config item for Rigaku imagers - already present");
}

Log::write(Log::LOGLEVEL_INFO, "Adding columns to shipmentdestination...");
database::query("ALTER TABLE `shipmentdestination` ADD `ismanaged` BOOLEAN NOT NULL DEFAULT FALSE COMMENT 'If true, IceBear manages this destination and UI should be read only' AFTER `projectid`;");
database::query("ALTER TABLE `shipmentdestination` ADD `geofence` TEXT NULL DEFAULT NULL COMMENT 'Defines a region around the destination. Lat,long,radius(m) or lat,long,lat,long,lat,long...' AFTER `baseuri`;");
database::query("ALTER TABLE `shipmentdestination` ADD `isavailable` BOOLEAN NOT NULL DEFAULT TRUE COMMENT 'Whether this destination can be selected for shipments' AFTER `ismanaged`;");
Log::write(Log::LOGLEVEL_INFO, "...added");


Log::write(Log::LOGLEVEL_INFO, "...update done");

