<?php /** @noinspection PhpUnhandledExceptionInspection */
/**
 * Upgrades the database from version 1.9.4 to version 1.10.0
 * DO NOT call this directly, it will fail.
 * To be included from classes/core/updater.class.php.
 * Assumes that logging has already been init()ed. Log class will throw ServerException if not.
 */
Log::write(Log::LOGLEVEL_INFO, "In updater, from 1.9.4 to 1.10.0...");

Log::write(Log::LOGLEVEL_INFO, "Adding edupersonprincipalname column to user table...");
database::addOrAlterColumn('user', 'edupersonprincipalname','VARCHAR(100) NULL DEFAULT NULL');
Log::write(Log::LOGLEVEL_INFO, "...done");


Log::write(Log::LOGLEVEL_INFO, "Adding lastlogin column to user table...");
database::addOrAlterColumn('user','lastlogin','DATETIME NULL DEFAULT NULL');
Log::write(Log::LOGLEVEL_INFO, "...done");

Log::write(Log::LOGLEVEL_INFO, "Adding privacy policy config items to config table...");
database::query("INSERT INTO `config` 
    (`name`, `description`, `type`, `enumvalues`, `minimum`, `maximum`, `defaultvalue`, `value`) VALUES 
	('core_privacypolicy_url', 'The URL of a privacy policy governing use of IceBear', 'text', NULL, NULL, NULL, '', ''), 
	('core_privacypolicy_linktext', 'The text of the privacy policy link (not the policy itself)', 'text', NULL, NULL, NULL, 'Privacy policy', 'Privacy policy')
");
Log::write(Log::LOGLEVEL_INFO, "...done");

Log::write(Log::LOGLEVEL_INFO, "Adding starrating column to autoprocessing result table...");
database::addOrAlterColumn('autoprocessingresult','starrating',"TINYINT UNSIGNED NOT NULL DEFAULT '0'");
Log::write(Log::LOGLEVEL_INFO, "...done");

Log::write(Log::LOGLEVEL_INFO, "Adding wavelength column to dataset result table...");
database::addOrAlterColumn('dataset','wavelength','FLOAT UNSIGNED NULL DEFAULT NULL');
Log::write(Log::LOGLEVEL_INFO, "...done");

Log::write(Log::LOGLEVEL_INFO, "...update done");

if(!class_exists('DOMDocument')) {
	Log::write(Log::LOGLEVEL_WARN, "DOMDocument class not found.");
	Log::write(Log::LOGLEVEL_WARN, "IceBear can't fetch standard screens from Formulatrix without this.");
	Log::write(Log::LOGLEVEL_WARN, "Future functionality may also depend on it.");
	Log::write(Log::LOGLEVEL_WARN, "Run 'apt install php-xml' and restart Apache to fix this.");
	Log::write(Log::LOGLEVEL_WARN, "Contact support if you need help.");
}

