<?php class skin implements crudable {

	protected static array $fields=array(
			'name'=>validator::REQUIRED,
			'friendlyname'=>validator::REQUIRED,
    	    'description'=>validator::REQUIRED,
	       //Themes: 'darkicons' or 'lighticons'
    	    'navbaricontheme'=>validator::REQUIRED,
    	    'boxheadericontheme'=>validator::REQUIRED,
    	    'treeheadericontheme'=>validator::REQUIRED,
    	    'bodyicontheme'=>validator::REQUIRED,
	);
	
	protected static array $helpTexts=array(
	);

	/**
	 * @param $key
	 * @param $value
	 * @param array $request
	 * @return array|null
	 * @throws BadRequestException
	 * @throws ServerException
	 */
	public static function getByProperty(string $key, string $value, array $request=[]): ?array {
	    if('name'==$key){
	        return static::getByName($value);
	    }
		$keys=array_keys(self::getFieldValidations());
		if(!in_array($key, $keys)){
			throw new BadRequestException('Property '.$key.' not recognised on Skin');
		}
		$sqlStatement='SELECT SQL_CALC_FOUND_ROWS * FROM skin 
				WHERE '.$key.'=:val ';
		$sqlStatement.=database::getOrderClause($request,'skin');
		$sqlStatement.=database::getLimitClause($request);
		$params=array(':val'=>$value);
		return database::queryGetAll($sqlStatement,$params);
	}

	/**
	 * @throws ServerException
	 * @throws BadRequestException
	 * @throws BadRequestException
	 */
	public static function getByProperties(array $keyValuePairs, $request=[]): ?array {
		$keys=array_keys(self::getFieldValidations());
		$sqlStatement='SELECT SQL_CALC_FOUND_ROWS * FROM skin WHERE 1=1 ';
		$params=[];
		foreach($keyValuePairs as $key=>$value){
			if(!in_array($key, $keys)){
				throw new BadRequestException('Property '.$key.' not recognised on Skin');
			}
			$sqlStatement.=" AND $key=:$key";
			$params[":$key"]=$value;
		}
		$sqlStatement.=database::getOrderClause($request,'skin');
		$sqlStatement.=database::getLimitClause($request);
		return database::queryGetAll($sqlStatement,$params);
	}


	public static function canCreate(): bool {
	    return false;
	}

	public static function canUpdate($id): bool {
	    return false;
	}
	
	public static function getFieldValidations(): array {
	    return static::$fields;
	}
	
	public static function getFieldHelpTexts(): array {
	    return static::$helpTexts;
	}

	/**
	 * @throws ServerException
	 * @throws BadRequestException
	 */
	public static function getAll(array $request=[]): ?array {
	    return database::queryGetAll('SELECT * FROM skin ORDER BY friendlyname ');
	}

	/**
	 * @throws ServerException
	 * @throws BadRequestException
	 */
	public static function getByName(string $name): ?array {
	    return database::queryGetOne('SELECT * FROM skin WHERE name=:name',array(':name'=>$name));
	}

	/**
	 * @throws ServerException
	 * @throws BadRequestException
	 */
	public static function getById(int $id): ?array {
	    return database::queryGetOne('SELECT * FROM skin WHERE id=:id',array(':id'=>$id));
	}

    /**
     * @param array $request
     * @throws BadRequestException
     */
	public static function create(array $request=[]): array {
	    throw new BadRequestException('Cannot create skins');
	}

	/**
	 * @param int $id
	 * @param array $request
	 * @return array
	 * @throws BadRequestException
	 */
	public static function update(int $id, array $request=[]): array {
	    throw new BadRequestException('Cannot update skins');
	}

	/**
	 * @param int $id
	 * @return array
	 * @throws BadRequestException
	 */
	public static function delete(int $id): array {
	    throw new BadRequestException('Cannot delete skins');
	}

	
}