<?php 

class userconfig {
	
	protected static array $fields=array(
			'name'=>validator::REQUIRED,
    	    'userid'=>validator::REQUIRED,
			'value'=>validator::ANY,
	);
	
	static function get(string $name): ?string {
	    $config=session::get('userConfig');
	    if(isset($config[$name])){
	        return $config[$name];
	    }
	    $userid=session::getUserId();
		$result=database::queryGetOne('SELECT value FROM userconfig WHERE userid=:userid AND name=:name', array(':userid'=>$userid, ':name'=>$name));
		if(!$result){ return null; }
		session::refreshUserConfig();
		return trim($result['value']);
	}

	/**
	 * @param string $name
	 * @param string $value
	 * @return bool
	 * @throws AuthorizationRequiredException
	 * @throws BadRequestException
	 * @throws ServerException
	 */
	public static function set(string $name, string $value): bool {
	    $userid=session::getUserId();
		if(!$userid){
			throw new AuthorizationRequiredException('You must be logged in to set user config values');
		}
		database::query('INSERT INTO userconfig (userid,name,value) VALUES(:userid,:name,:value1) ON DUPLICATE KEY UPDATE value=:value2', 
		    array(':name'=>$name, ':userid'=>$userid, ':value1'=>trim($value), ':value2'=>trim($value)));
		session::refreshUserConfig();
		return true;
	}

    /**
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws ServerException
     * @noinspection PhpUnusedParameterInspection
     */
	public static function getAll(array $request=[]): array {
	    $userid=session::getUserId();
	    if(!$userid){ return static::$loggedOutConfig; }
	    $config=session::get('userConfig');
	    if(!empty($config)){
	        return $config;
	    }
	    $result=database::queryGetAll('SELECT name,value FROM userconfig WHERE userid=:userid ORDER BY name ', array(':userid'=>$userid));
	    if(!$result){ return array(); }
		$ret=array();
		foreach($result['rows'] as $row){
		    $ret[$row['name']]=$row['value'];
		}
		return $ret;
	}

	private static array $loggedOutConfig=array(
	    'skin'=>'default'
	);

	/**
	 * @param int $id
	 * @return array|null
	 * @throws BadRequestException
	 * @noinspection PhpUnusedParameterInspection
	 */
	static function getById(int $id): ?array {
		throw new BadRequestException('getById not implemented on userconfig');
	}

	/**
	 * @param string $name
	 * @return array|null
	 * @throws BadRequestException
	 * @noinspection PhpUnusedParameterInspection
	 */
	static function getByName(string $name): ?array {
		throw new BadRequestException('getByName not implemented on userconfig');
	}

	/**
	 * @param string $key
	 * @param string $value
	 * @param array $request
	 * @return array|null
	 * @throws BadRequestException
	 * @noinspection PhpUnusedParameterInspection
	 */
	static function getByProperty(string $key, string $value, array $request=[]): ?array {
		throw new BadRequestException('getByProperty not implemented on userconfig');
	}

	/**
	 * @param array $keyValuePairs
	 * @param array $request
	 * @throws BadRequestException
	 * @noinspection PhpUnusedParameterInspection
	 */
	static function getByProperties(array $keyValuePairs, array $request=[]): ?array {
		throw new BadRequestException('getByProperty not implemented on userconfig');
	}

}