<?php class LightBugTracker extends Device {

    const USERNAME='lightbug';
    const USERFULLNAME='LightBug Trackers';

    const LOGLEVEL=Log::LOGLEVEL_DEBUG;

	/**
	 * @param array $request
	 * @return array|false|string
	 * @throws BadRequestException
	 * @throws ServerException
	 */
    public static function PushNotification(array $request): bool|array|string {
        $logPaths=array('/var/log/icebear', 'C:/icebearlogs', config::get('core_imagestore'));
        foreach($logPaths as $path){
            $path=rtrim($path,'/').'/';
            if(file_exists($path)){
                Log::init(static::LOGLEVEL, $path.'LightBugTracker_'.gmdate('Y-m-d').'.log');
                break;
            }
        }
        if(!Log::isInited()){
            throw new ServerException('Cannot initiate logging because no suitable paths exist');
        }
        Log::info('Push received. Body follows:');
        Log::info('++++++++++++++');
        Log::info(json_encode($request));
        Log::info('++++++++++++++');
        switch ($request['type']){
            case 'SubscriptionConfirmation':
                $result=static::handleSubscriptionConfirmation($request);
                break;
            case 'Notification':
                $result=static::handleNotification($request);
                break;
            default:
                $result=static::handleUnsupportedPushType($request);
        }
        Log::info('=============');
        Log::end();
        return $result;
    }

    /**
     * LightBug requires confirmation before any notifications will be sent to a given endpoint.
     * This happens only once. All we need to do is make a request to the URL sent to us.
     * @param $request array The push from LightBug, as an associative array
     * @return false|string
     * @throws ServerException
     */
    private static function handleSubscriptionConfirmation(array $request): bool|string {
        Log::info('Message is a subscription confirmation');
        Log::debug('Calling the specified subscribe URL...');
        $result=file_get_contents($request['SubscribeURL']);
        Log::info('Result follows');
        Log::info('++++++++++++++');
        Log::info($result);
        Log::info('++++++++++++++');
        Log::debug('Returning from handler');
        return $result;
    }

    /**
     * Handle a push notification.
     * @param $request array The push from LightBug, as an associative array
     * @throws ServerException
     */
    private static function handleNotification(array $request): array {
        Log::info('Message is a push notification');
        //TODO For now, just log it
        Log::debug('Returning from handler');
        return $request;
    }

    /**
     * Handle an unexpected and unsupported push message. Log it and return OK. Mail it to support?
     * @param array $request
     * @return mixed
     * @throws ServerException
     */
    private static function handleUnsupportedPushType(array $request): array {
        Log::info('Message is an unsupported type');
        //TODO For now, just log it
        Log::debug('Returning from handler');
        return $request;
    }

}