<?php class beamline extends baseobject {

    protected static array $fields=array(
        'name'=>validator::REQUIRED,
        'shipmentdestinationid'=>array(validator::REQUIRED, validator::INTEGER),
        'detectormanufacturer'=>validator::ANY,
        'detectormodel'=>validator::ANY,
        'detectortype'=>validator::ANY,
    );

    protected static array $helpTexts=array(

    );

	protected static string $adminSelect='SELECT SQL_CALC_FOUND_ROWS beamline.*, shipmentdestination.name AS shipmentdestinationname
        FROM beamline, shipmentdestination, project
        WHERE beamline.shipmentdestinationid=shipmentdestination.id
            AND beamline.projectid=project.id
    ';
    protected static string $normalSelect='SELECT SQL_CALC_FOUND_ROWS beamline.*, shipmentdestination.name AS shipmentdestinationname
        FROM beamline, shipmentdestination, project
        WHERE beamline.shipmentdestinationid=shipmentdestination.id
            AND beamline.projectid=project.id
    ';
    public static string $defaultSortOrder='shipmentdestination.name, beamline.name';

    public static function create(array $request=[]): array {
		shipment::setShipperAdmin();
        $sharedProject=project::getByName(baseproject::SHARED);
		if(!$sharedProject){
			throw new NotFoundException('Could not read shared project');
		}
        $request["projectid"]=$sharedProject['id'];
        $ret=parent::create($request);
		shipment::revertShipperAdmin();
		return $ret;
    }

    /**
     * @return bool
     * @throws NotFoundException
     */
    public static function canCreate(): bool {
        return session::isShipper() || session::isAdmin();
    }

	/**
	 * @param int $id
	 * @return bool
	 * @throws NotFoundException
	 */
    public static function canUpdate(int $id): bool {
        return session::isShipper() || session::isAdmin();
    }

}