<?php class containertype extends baseobject { 
	
	protected static array $fields=array(
		'name'=>validator::REQUIRED,
		'containercategoryid'=>array(validator::REQUIRED, validator::INTEGER),
		'positions'=>array(validator::REQUIRED, validator::INTEGER),
	);
	
	protected static array $helpTexts=array(
		'name'=>'A unique identifier for the container category',
		'containercategoryid'=>'The broad category of container, e.g., Puck',
		'positions'=>'How many items can be held in containers of this type',
	);

	protected static string $adminSelect='SELECT SQL_CALC_FOUND_ROWS containertype.*, 
				containercategory.name AS containercategoryname, containercategory.userscancreate AS userscancreate
			FROM containertype, containercategory, project
			WHERE project.id= containertype.projectid AND containercategory.id=containertype.containercategoryid ';
	protected static string $normalSelect='SELECT SQL_CALC_FOUND_ROWS containertype.*, 
				containercategory.name AS containercategoryname, containercategory.userscancreate AS userscancreate
			FROM containertype, containercategory, project
			WHERE project.id= containertype.projectid AND containercategory.id=containertype.containercategoryid ';

    /**
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws ForbiddenException
     * @throws NotFoundException
     * @throws ServerException
     */
	public static function create(array $request=[]): array {
		if(!static::canCreate()){
			throw new ForbiddenException('Only administrators and technicians can create container types');
		}
		$project=project::getByName(baseproject::SHARED);
		if(!$project){
			throw new NotFoundException('Could not read shared project');
		}
		$request['projectid']=$project['id'];
        return parent::createByClassName($request,'containertype');
	}

	/**
	 * @return bool
	 * @throws BadRequestException
	 * @throws NotFoundException
	 * @throws ServerException
	 */
	public static function canCreate(): bool {
		if(session::isAdmin()){ return true; }
		$grp=usergroup::getByName(usergroup::TECHNICIANS);
		return usergroup::userisingroup($grp['id']);
	}
	
}