<?php class datasetlocation extends baseobject {

    protected static array $fields=array(
        'name'=>validator::ANY, //generated automatically
        'datasetid'=>[VALIDATOR::REQUIRED, validator::INTEGER],
        'type'=>validator::REQUIRED,
		'datalocation'=>validator::REQUIRED,
    );

    protected static array $helpTexts=array(
        'datasetid'=>'The dataset to which this location refers',
        'type'=>'One of Original, Intermediate, Open-Access, Other',
        'datalocation'=>'The path, URL, or DOI where the raw data can be found'
    );


    public static function create(array $request=[]): array {
		shipment::setShipperAdmin();
        $datasetId=$request['datasetid'];
        if(!$datasetId){ throw new BadRequestException("Dataset ID not specified"); }
        $dataset=dataset::getById($datasetId);
        if(!$dataset){ throw new NotFoundException("Dataset not found"); }
        $request['projectid']=$dataset['projectid'];
        $request['name']='datasetlocation'.microtime(true);
        $ret=parent::create($request);
		shipment::revertShipperAdmin();
        return $ret;
    }

    public static function update(int $id, array $request=[]): array {
		shipment::setShipperAdmin();
        $ret=parent::update($id, $request);
		shipment::revertShipperAdmin();
        return $ret;
    }


    /**
     * @return bool
     */
    public static function canCreate(): bool {
        return true; //but checked in create()
    }

	/**
	 * @param int $id
	 * @return bool
	 */
    public static function canUpdate(int $id): bool {
        return true; //but checked in create()
    }

}