<?php class imager extends baseobject { 
	
	protected static array $fields=array(
		'name'=>validator::REQUIRED,
		'friendlyname'=>validator::REQUIRED,
		'manufacturer'=>validator::REQUIRED,
		'temperature'=>array(validator::REQUIRED, validator::INTEGER),
		'platecapacity'=>array(validator::REQUIRED, validator::INTEGER),
		'platesactive'=>array(validator::INTEGER),
		'platesexpired'=>array(validator::INTEGER),
		'alertlevel'=>array(validator::REQUIRED, validator::INTEGER),
		'warninglevel'=>array(validator::REQUIRED, validator::INTEGER),
        'manualimaging'=>validator::BOOLEAN,
		'isinuse'=>validator::BOOLEAN
	);
	
	protected static array $helpTexts=array(
		'name'=>'A unique identifier for the imager',
		'friendlyname'=>'A human-friendly name like "20-degree imager"',
		'manufacturer'=>'The manufacturer name',
		'temperature'=>'The normal temperature in the imager',
		'platecapacity'=>'How many plates the imager can hold',
		'platesactive'=>'How many plates in the imager have inspections scheduled',
		'platesexpired'=>'How many plates in the imager have no inspections scheduled',
		'alertlevel'=>'Plate count when imager is "filling up"',
		'warninglevel'=>'Plate count when imager is "almost full"',
		'manualimaging'=>'Imager is for manually-added plate inspections, e.g., microscope',
        'isinuse'=>'Whether the imager is installed. Set false when retiring the imager.'
	);
	
	public static function create(array $request=[]): array {
		$project=project::getByName(baseproject::SHARED);
		if(!$project){
			throw new NotFoundException('Could not read shared project');
		}
		$request['projectid']=$project['id'];
        return parent::createByClassName($request,'imager');
	}

	/**
	 * @param int $id
	 * @param array $request
	 * @return array
	 * @throws BadRequestException
	 * @throws ForbiddenException
	 * @throws NotFoundException
	 * @throws NotModifiedException
	 * @throws ServerException
	 */
	public static function update(int $id, array $request=[]): array {
        if(isset($request['isinuse']) && 0===1*$request['isinuse']){
            $plates=imager::getplates($id, $request);
            if(isset($plates['rows'])){
                foreach($plates['rows'] as $plate){
                    plate::update($plate['id'],['locationid'=>database::$nullValue]);
                }
            }
        }
        return parent::update($id, $request);
    }

	/**
	 * @param int $id
	 * @param array $request
	 * @return array|null
	 * @throws BadRequestException
	 * @throws ServerException
	 */
	public static function getimagingsessions(int $id, array $request=[]): ?array {
		return imagingsession::getByProperty('imagerid', $id, $request);
	}

	/**
	 * @param int $id
	 * @param array $request
	 * @return array|null
	 * @throws BadRequestException
	 * @throws ServerException
	 */
	public static function getplates(int $id, array $request=[]): ?array {
		return plate::getByProperty('locationid', $id, $request);
	}

	/**
	 * @param int $id
	 * @param array $request
	 * @return array|null
	 * @throws BadRequestException
	 * @throws ServerException
	 */
	public static function getimagerloadlogs(int $id, array $request=[]): ?array {
		return imagerloadlog::getByProperty('imagerid', $id, $request);
	}
	
	
}