<?php class imagingparametersversion extends baseobject {
	
	protected static array $fields=array(
			'name'=>validator::REQUIRED,
			'manufacturerdatabaseid'=>array(validator::REQUIRED,validator::INTEGER),
			'imagingparametersid'=>array(validator::REQUIRED,validator::INTEGER)
	);
	
	protected static array $helpTexts=array(
			'name'=>'A unique name for this set of imaging parameters',
			'manufacturerdatabaseid'=>'The ID of this version in the imager manufacturer database',
			'imagingparametersid'=>'The database ID of the parent Imaging Parameters, of which this is a version'
	);

	/**
	 * @param int $id
	 * @param array $request
	 * @return array|null
	 * @throws BadRequestException
	 * @throws ServerException
	 */
	public static function getimagersettings(int $id,array $request=[]): ?array {
		return imagingsetting::getByProperty('imagingparametersversionid', $id, $request);
	}
	
}