<?php class note extends basenote {

    /**
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws ForbiddenException
     * @throws NotFoundException
     * @throws ServerException
     */
    public static function create(array $request=[]): array {
        if(session::isShipper() && !session::isAdmin()){
            session::becomeAdmin();
        }
        try {
            $ret=parent::create($request);
            session::revertAdmin();
            return $ret;
        } catch (NotFoundException|ForbiddenException|ServerException|BadRequestException $e){
            session::revertAdmin();
            throw $e;
        }
	}

}