<?php class pdbdepositioncrystal extends baseobject {

    protected static array $fields=array(
        'name'=>validator::ANY, //required but autogenerated
        'pdbdepositionid'=>array(validator::REQUIRED, validator::INTEGER),
        'crystalid'=>array(validator::REQUIRED, validator::INTEGER)
    );

    protected static array $helpTexts=array(
        'name'=>'Auto-generated',
        'pdbdepositionid'=>'The ID of the PDB deposition record',
        'crystalid'=>'The ID of the crystal record',
    );

    public static function create(array $request=[]): array {
        //TODO This should be a baseobject::validate function!
        foreach(static::$fields as $fname=>$validations){
            if(isset($request[$fname])){
                validator::validate($fname, $request[$fname], $validations);
            } else {
                validator::validate($fname, null, $validations);
            }
        }
        $crystal=crystal::getById($request['crystalid']);
        $pdb=pdbdeposition::getById($request['pdbdepositionid']);
        if(!$crystal){
            throw new BadRequestException('That crystal does not exist, or you do not have permission to see it.');
		} else if(!project::canUpdateInProject($crystal['projectid'])){
			throw new ForbiddenException('You do not have permission to update this crystal.');
		}
        if(!$pdb){
            throw new BadRequestException('No PDB deposition record with that ID');
        }
        $request['name']='pdbdeposition'.$pdb['id'].'_crystal'.$crystal['id'];
        $request['projectid']=$crystal['projectid'];
        return parent::create($request);
    }

}