<?php

class platewell extends baseobject {
	
	protected static array $fields=array(
			'name'=>validator::REQUIRED,
			'plateid'=>array(validator::REQUIRED, validator::INTEGER),
			'row'=>array(validator::REQUIRED, validator::INTEGER),
			'col'=>array(validator::REQUIRED, validator::INTEGER),
	);
	
	protected static array $helpTexts=array(
			'name'=>'A unique name for this plate well',
			'plateid'=>'The parent plate',
			'row'=>'Row number',
			'col'=>'Column number',
	);
	
	private static string $rowLabels='-ABCDEFGHIJKLMNOPQRSTUVWXYZ';

    /**
     * @return string
     * @noinspection PhpUnused
     */
	public static function getRowLabels(): string {
		return static::$rowLabels;
	}
	
	public static function getWellLabel(int $rowNumber, int $colNumber): string {
		return self::$rowLabels[(int)$rowNumber].str_pad($colNumber,2,'0',STR_PAD_LEFT);
	}
	
	public static function create(array $request=[]): array {
		if(!isset($request['plateid'])){ throw new BadRequestException('No plate ID supplied to platewell::create'); }
		$plate=plate::getById($request['plateid']);
		if(!isset($request['name'])){
			$name=$plate['name'].'_'.self::$rowLabels[$request['row']].str_pad($request['col'],2,'0',STR_PAD_LEFT);
			$request['name']=$name;
		}
		$created=parent::createByClassName($request,'platewell');
		$well=$created['created'];
		$plateType=platetype::getById($plate['platetypeid']);
		$numDrops=$plateType['subs'];
		$drop=array(
				'platewellid'=>$well['id'],
				'projectid'=>$well['projectid'],
		);
		for($d=1;$d<=$numDrops;$d++){
			$drop['dropnumber']=$d;
			$drop['name']=$well['name'].'.'.$d;
			welldrop::create($drop);
		}
		return $well;
	}
	
}