<?php class screencondition extends baseobject {
	
	protected static array $fields=array(
			'name'=>validator::REQUIRED,
			'wellnumber'=>array(validator::REQUIRED,validator::INTEGER),
			'row'=>array(validator::REQUIRED,validator::INTEGER),
			'col'=>array(validator::REQUIRED,validator::INTEGER),
			'screenid'=>array(validator::REQUIRED,validator::INTEGER),
			'description'=>validator::REQUIRED,
	);
	
	protected static array $helpTexts=array(
			'name'=>'A unique name for this screen condition',
			'wellnumber'=>'The well number (typically 1-96)',
			'row'=>'The plate row',
			'col'=>'The plate column',
			'screenid'=>'The parent screen',
			'description'=>'A human-readable description of the condition',
	);
	
	public static string $defaultSortOrder='wellnumber ASC, `row` ASC, `col` ASC';

    /**
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws ForbiddenException
     * @throws NotFoundException
     * @throws ServerException
     */
	public static function create(array $request=[]): array {
		$screen=screen::getById($request['screenid']);
		$projectId=$screen['projectid'];
		$request['projectid']=$projectId;
		return parent::create($request);
	}

	/**
	 * @param int $id
	 * @return bool
	 * @throws BadRequestException
	 * @throws NotFoundException
	 * @throws ServerException
	 */
	public static function canUpdate(int $id): bool {
		return screen::canUpdate($id);
	}
	
}