<?php /** @noinspection PhpUnused */

class task implements crudable {

	/**
	 * @throws ForbiddenException
	 * @throws NotFoundException
	 * @throws BadRequestException
	 * @throws ServerException
	 */
	public static function getAll(array $request=[]): ?array {
		$parts=array();
		$params=array();
		if(session::isAdmin()){
			//plate types with default drop mapping
			//users with name starting AUTO
			$parts[]="SELECT 'user' AS type, 1 AS priority, id, name, 'Set username and activate' AS description FROM user WHERE name LIKE 'AUTO%'";
			//plates with owner unknownuser
			$defaultOwner=user::getByName(user::UNKNOWNUSER_USERNAME);
			if(!$defaultOwner){
				$defaultOwner=user::create([
					'name'=>user::UNKNOWNUSER_USERNAME,
					'fullname'=>'Unknown user',
					'email'=>user::UNKNOWNUSER_USERNAME.'@bogus.bogus',
					'password'=>'UselessPassword',
					'isactive'=>false
				])['created'];
				database::commit();
				database::begin();
			}
			$parts[]="SELECT 'plate' AS type, 2 AS priority, plate.id, plate.name, 'Set the plate owner' AS description 
				FROM plate,project WHERE plate.projectid=project.id AND project.isarchived=0 AND ownerid=:ownerid";
			$params[':ownerid']=$defaultOwner['id'];
		}

		//Expired plates - zero (but not null) inspections remaining
		$expiredSql="SELECT 'plate' as type, 3 AS priority, plate.id AS id, plate.name AS name, CONCAT('Remove expired plate from ', imager.friendlyname) AS description
					FROM plate, imager where imager.id=plate.locationid AND plate.inspectionsremaining=0 ";
		if(!session::isAdmin()){
			$expiredSql.=" AND plate.ownerid=:ownerid2";
			$params[':ownerid2']=session::getUserId();
		}
		$parts[]=$expiredSql;
		
		//Zombie plates - have at least one inspection remaining, but final one scheduled for over a week ago
		$zombieSql="SELECT 'plate' as type, 3 AS priority, plate.id AS id, plate.name AS name, CONCAT('Remove zombie plate from ', imager.friendlyname) AS description
					FROM plate, imager 
					WHERE imager.id=plate.locationid AND plate.finalinspectiontime<NOW() - INTERVAL 1 WEEK AND plate.inspectionsremaining>0";
		if(!session::isAdmin()){
			$zombieSql.=" AND plate.ownerid=:ownerid3";
			$params[':ownerid3']=session::getUserId();
		}
		$parts[]=$zombieSql;
		
		//plates owned by userid with screenid=null and/or hasconstructs=false
		$parts[]="SELECT 'plate' AS type, 5 AS priority, plate.id, plate.name,
				CASE 
					WHEN screenid IS NULL AND plate.hasconstructs=FALSE THEN 'Set the protein and screen' 
					WHEN screenid IS NULL THEN 'Set the screen' 
					ELSE 'Set the protein'
				END AS description 
				FROM plate,project WHERE (screenid IS NULL OR plate.hasconstructs=FALSE) 
				                     AND project.id=plate.projectid AND project.isarchived=0 AND ownerid=:ownerid4";
		$params[':ownerid4']=session::getUserId();

		
		$query="(" .implode(") UNION (", $parts) .") ORDER BY priority, id";
		//$query.=database::getProjectClause("read");
		$query.=database::getLimitClause($request);
		return database::queryGetAll($query, $params);
	}
	
	/* "Implement" remaining methods in crudable to ensure clean failure */

    /**
     * @throws BadRequestException
     */
	public static function getFieldValidations(): array {
		throw new BadRequestException('Not implemented');
	}

    /**
     * @throws BadRequestException
     */
	public static function getFieldHelpTexts(): array {
		throw new BadRequestException('Not implemented');
	}

	/**
	 * @param int $id
	 * @return array|null
	 * @throws BadRequestException
	 */
	public static function getById(int $id): ?array {
		throw new BadRequestException('Not implemented');
	}

	/**
	 * @param string $name
	 * @return array|null
	 * @throws BadRequestException
	 */
	public static function getByName(string $name): ?array {
		throw new BadRequestException('Not implemented');
	}

	/**
	 * @param string $key
	 * @param string $value
	 * @param array $request
	 * @return array|null
	 * @throws BadRequestException
	 */
	public static function getByProperty(string $key, string $value, array $request=[]): ?array {
		throw new BadRequestException('Not implemented');
	}

	/**
	 * @param array $keyValuePairs
	 * @param array $request
	 * @return array|null
	 * @throws BadRequestException
	 */
	public static function getByProperties(array $keyValuePairs, array $request=[]): ?array {
		throw new BadRequestException('Not implemented');
	}

	/**
     * @throws BadRequestException
     */
	public static function canCreate(): bool {
		throw new BadRequestException('Not implemented');
	}

	/**
	 * @param int $id
	 * @return bool
	 * @throws BadRequestException
	 */
	public static function canUpdate(int $id): bool {
		throw new BadRequestException('Not implemented');
	}

    /**
     * @param array $request
     * @throws BadRequestException
     */
	public static function create(array $request=[]): array {
		throw new BadRequestException('Not implemented');
	}

	/**
	 * @param int $id
	 * @param array $request
	 * @return array
	 * @throws BadRequestException
	 */
	public static function update(int $id, array$request=[]): array {
		throw new BadRequestException('Not implemented');
	}

	/**
	 * @param int $id
	 * @return array
	 * @throws BadRequestException
	 */
	public static function delete(int $id): array {
		throw new BadRequestException('Not implemented');
	}
	
}