Homepage.registerBrick({
	name:"fi_oulu_AllPlatesByProject",
	title:"Latest plates, by project",
	description:"A list of the most recent plates (yours or not), by project.",
	version:1,
	height:2,
	width:1,
	url:"/api/project/isarchived/0",
	sortBy:"name",
	onSuccess:function(transport,box){
		let projects=transport.responseJSON.rows;
		let bb=box.querySelector(".boxbody");
		bb.innerHTML="";
		projects.forEach(function(p){
			if(1*p.owner!==userId){ return; }
			bb.treeItem({ 
				id:'fi_oulu_AllPlatesByProject_proj'+p.id,
				header:'<a href="/project/'+p.id+'">'+p.name+'</a> (mine)',
				record:p,
				updater:this.getPlatesForProject
			});
		});
		projects.forEach(function(p){
			if(1*p.owner===userId){ return; }
			bb.treeItem({ 
				id:'fi_oulu_AllPlatesByProject_proj'+p.id,
				header:'<a href="/project/'+p.id+'">'+p.name+'</a>',
				record:p,
				updater:this.getPlatesForProject
			});
		});
	},

	onFailure:function(transport,box){
		let error="Could not get projects.";
		if(transport.responseJSON && transport.responseJSON.error){
			error=transport.responseJSON.error;
		}
		box.querySelector(".boxbody").innerHTML=error;
	},
	
	getPlatesForProject: function(clicked){
		let treeItem=clicked.closest(".treeitem");
		let projectid=treeItem.record.id;
		new AjaxUtils.Request("/api/plate/projectid/"+projectid+"?pagesize=25&pagenumber=1&sortby=name&sortdescending=1",{
			method:"get",
			onSuccess:function(transport){ this.getPlatesForProject_onSuccess(transport,treeItem)}.bind(this),
			onFailure:function(transport){ this.getPlatesForProject_onFailure(transport,treeItem)}.bind(this),
		});
	},
	getPlatesForProject_onSuccess: function(transport,treeItem){
		let t=ui.table({
			headers:['Plate','Owner'],
			cellTemplates:[
				'<a href="/plate/{{id}}">{{name}}</a>',
				'<a href="/user/{{ownerid}}">{{ownername}}</a>'
			]
		}, transport.responseJSON, treeItem.querySelector(".treebody") );
		let rows=t.querySelectorAll("tr");
		rows[rows.length-1].remove();
	},
	getPlatesForProject_onFailure: function(transport,treeItem){
		let error="Could not get plates.";
		if(transport.responseJSON && transport.responseJSON.error){
			error=transport.responseJSON.error;
		}
		treeItem.querySelector(".treebody").innerHTML=error;
	},

});