<?php

require dirname(realpath(__FILE__),3).'/vendor/autoload.php';
header('Content-Type: text/plain');

try {
    if(!Log::isInited()){
        Log::init(Log::LOGLEVEL_DEBUG);
    }
    Log::info('Connecting to database');
    database::connect();
    Log::info('Getting session');
    session::init(new PhpSession());
    Log::info('Parsing brick files');
    homepagebrick::parseBrickFiles();
    Log::info('Done parsing brick files');
} catch (Exception $e) {
    if (Log::isInited()) {
        /** @noinspection PhpUnhandledExceptionInspection */
        Log::error($e->getMessage());
        /** @noinspection PhpUnhandledExceptionInspection */
        Log::error($e->getTraceAsString());
    } else {
        echo $e->getMessage();
        echo $e->getTraceAsString();
    }
}