<?php
include_once(dirname(__DIR__,3).'/client/help/_common/helphead.php');
?>
<h1>Usergroups</h1>
<p>IceBear users can be put into usergroups. Usergroups, in turn, can be given permissions on projects.</p>
<p>Some special groups are used to grant additional privileges to key users.</p>

<h2>Special usergroups</h2>
<p>The &quot;Everyone&quot; usergroup contains all registered users. New users are automatically added to this group.</p>
<p>The &quot;Administrators&quot; usergroup contains users who are allowed to administer the application. They can run system updates, and
can see all data and perform any action. Be very careful about who you add to this usergroup.</p>
<p>The &quot;Shippers&quot; usergroup contains users who are allowed to send shipments to the synchrotron.</p>
<p>The &quot;Supervisors&quot; usergroup contains all users who are assigned as supervisor to at least one user. Membership is managed
    automatically, but you can add users to this group.</p>
<p>The &quot;Technicians&quot; usergroup has some special permissions throughout the application.</p>

<h2>Creating a usergroup</h2>
<p>From the main menu, select <strong>Create a usergroup</strong>. Or, from the list of usergroups, click the <strong>Create new...</strong>
    link in the page header.</p>
<figure>
    <img alt="" src="create.png" />
    <figcaption>The usergroup creation page.</figcaption>
</figure>
<p>Give your new usergroup a name, and write a brief description.</p>
<p>You can decide who can see the usergroup. If you choose <strong>Visible</strong>, any logged-in user can see that the usergroup
    exists. <strong>Members only</strong> means that the group cannot be seen by anyone outside the group. <strong>Hidden</strong>
    means that even members of the group don't know that it exists.</p>
<p>You can also decide who can see the membership of the usergroup (assuming that the group visibility setting allows them to see the group).
    If you choose <strong>Visible</strong>, anyone who can see the group can see who is in it. <strong>Members only</strong> means that only
    the group members can see who else is in the group. <strong>Hidden</strong> means that even members of the group don't know who else is
    in the group.</p>
<p>Click <strong>Create</strong> to create the usergroup. You will see the new usergroup's page.</p>

<h2>Viewing and managing a usergroup</h2>
<p>Depending on your permissions, some or all of this view will be editable. For some special usergroups, the name and description cannot be
    changed.</p>
<figure>
    <img alt="" src="view_members.png" />
    <figcaption>The usergroup page, showing the group members.</figcaption>
</figure>
<h3>Basic details</h3>
<p>These are as described in "Creating a usergroup" above, with two extra fields. Members of the group may have permission to create projects
and/or usergroups.</p>

<h3>The Members tab</h3>
<p>This tab shows all the members of the usergroups. Some members may be shown as group admins; they have the right to manage the group
    membership.</p>
<p>If you are an IceBear administrator, or are a member of this usergroup with group admin
    privileges, you can add or remove members and grant or remove group admin privileges.</p>

<h3>The Permissions tab</h3>
<figure>
    <img alt="" src="view_permissions.png" />
    <figcaption>The usergroup page, showing the group's project permissions.</figcaption>
</figure>
<p>This tab shows the group's project permissions. Note that this may not be complete; if you don't have permission to see a project, it won't
    appear here.</p>
<p>Depending on your privileges, you may be able to edit these permissions for some or all projects shown. It's recommended that you give the
    usergroup either just <strong>Read</strong> or all of <strong>Read</strong>, <strong>Create</strong>, <strong>Update</strong>, and
    <strong>Delete</strong>. A future version of IceBear will simplify this tab.</p>

<?php
include_once(dirname(__DIR__,3).'/client/help/_common/helpfoot.php');
?>
