<?php $pageTitle='Projects';
$showCreateLink=session::canCreateProjects();
include realpath(__DIR__).'/../_common/header.php'; ?>
<script type="text/javascript">
window.addEventListener('DOMContentLoaded',function(){


    let headers = ['Name', 'Description'];
    let cellTemplates = ['<a href="/project/{{id}}">{{name}}</a>', '{{description}}'];
    let showFilters = [true, true];
    let sortOrders = ['name', 'description'];
    if(isAdmin){
		headers=['Name','Owner','Description','System'];
		cellTemplates=['<a href="/project/{{id}}">{{name}}</a>','<a href="/user/{{owner}}">{{ownername}}</a>','{{description}}',[ui.checkmark,'issystem'] ];
        showFilters=[true,true,true,false];
        sortOrders=['name','user.name','description','project.issystem'];
	}
    if(Project.showArchivedProjects) {
        headers.push("Archived");
        cellTemplates.push([ui.checkmark,'isarchived']);
        showFilters.push(false);
        sortOrders.push('isarchived');
    }

    let archivedControl='Archived projects are hidden. <input onclick="Project.setShowArchivedProjectsFromProjectList(this,1);return false" type="button" style="float:none" value="Show archived projects" />';
    if(Project.showArchivedProjects) {
        archivedControl = 'Archived projects are included in this list. <input onclick="Project.setShowArchivedProjectsFromProjectList(this,0);return false" type="button" style="float:none" value="Hide archived projects" />';
    }
	ui.grid().box({
        contentBefore:archivedControl,
		classes:'r1 c1 h3 w3',
		url:'/api/project',
		headers:headers,
		cellTemplates:cellTemplates,
        showFilters:showFilters,
        sortOrders:sortOrders
	});


});
</script>
<?php include realpath(__DIR__).'/../_common/footer.php';